# Copyright 2022 Google.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Synthetic text data for training.
"""


# Excerpt from "The Illiad", by Homer, translation by Edward, Earl of Derby.
# Text from project Gutenberg, public domain.
text1_illiad_book1 = b"""
Achilles sing, O Goddess! Peleus' son;
His wrath pernicious, who ten thousand woes
Caused to Achaia's host, sent many a soul
Illustrious into Ades premature,
And Heroes gave (so stood the will of Jove)5
To dogs and to all ravening fowls a prey,
When fierce dispute had separated once
The noble Chief Achilles from the son
Of Atreus, Agamemnon, King of men.
Who them to strife impell'd? What power divine?10
Latona's son and Jove's.[1] For he, incensed
004 Against the King, a foul contagion raised
In all the host, and multitudes destroy'd,
For that the son of Atreus had his priest
Dishonored, Chryses. To the fleet he came15
Bearing rich ransom glorious to redeem
His daughter, and his hands charged with the wreath
And golden sceptre[2] of the God shaft-arm'd.
His supplication was at large to all
The host of Greece, but most of all to two,20
The sons of Atreus, highest in command.
Ye gallant Chiefs, and ye their gallant host,
(So may the Gods who in Olympus dwell
Give Priam's treasures to you for a spoil
And ye return in safety,) take my gifts25
And loose my child, in honor of the son
Of Jove, Apollo, archer of the skies.[3]
At once the voice of all was to respect
The priest, and to accept the bounteous price;
But so it pleased not Atreus' mighty son,30
Who with rude threatenings stern him thence dismiss'd.
Beware, old man! that at these hollow barks
I find thee not now lingering, or henceforth
Returning, lest the garland of thy God
005 And his bright sceptre should avail thee nought.35
I will not loose thy daughter, till old age
Steal on her. From her native country far,
In Argos, in my palace, she shall ply
The loom, and shall be partner of my bed.
Move me no more. Begone; hence while thou may'st.40
He spake, the old priest trembled and obey'd.
Forlorn he roamed the ocean's sounding shore,
And, solitary, with much prayer his King
Bright-hair'd Latona's son, Phoebus, implored.[4]
God of the silver bow, who with thy power45
Encirclest Chrysa, and who reign'st supreme
In Tenedos and Cilla the divine,
Sminthian[5] Apollo![6] If I e'er adorned
Thy beauteous fane, or on the altar burn'd
The fat acceptable of bulls or goats,50
Grant my petition. With thy shafts avenge
On the Achaian host thy servant's tears.
Such prayer he made, and it was heard.[7] The God,
Down from Olympus with his radiant bow
006 And his full quiver o'er his shoulder slung,55
Marched in his anger; shaken as he moved
His rattling arrows told of his approach.
Gloomy he came as night; sat from the ships
Apart, and sent an arrow. Clang'd the cord
[8]Dread-sounding, bounding on the silver bow.[9]60
Mules first and dogs he struck,[10] but at themselves
Dispatching soon his bitter arrows keen,
Smote them. Death-piles on all sides always blazed.
Nine days throughout the camp his arrows flew;
The tenth, Achilles from all parts convened65
The host in council. Juno the white-armed
Moved at the sight of Grecians all around
Dying, imparted to his mind the thought.[11]
The full assembly, therefore, now convened,
Uprose Achilles ardent, and began.70
007 Atrides! Now, it seems, no course remains
For us, but that the seas roaming again,
We hence return; at least if we survive;
But haste, consult we quick some prophet here
Or priest, or even interpreter of dreams,75
(For dreams are also of Jove,) that we may learn
By what crime we have thus incensed Apollo,
What broken vow, what hecatomb unpaid
He charges on us, and if soothed with steam
Of lambs or goats unblemish'd, he may yet80
Be won to spare us, and avert the plague.
He spake and sat, when Thestor's son arose
Calchas, an augur foremost in his art,
Who all things, present, past, and future knew,
And whom his skill in prophecy, a gift85
Conferred by Phoebus on him, had advanced
To be conductor of the fleet to Troy;
He, prudent, them admonishing, replied.[12]
Jove-loved Achilles! Wouldst thou learn from me
What cause hath moved Apollo to this wrath,90
The shaft-arm'd King? I shall divulge the cause.
But thou, swear first and covenant on thy part
That speaking, acting, thou wilt stand prepared
To give me succor; for I judge amiss,
Or he who rules the Argives, the supreme95
O'er all Achaia's host, will be incensed.
Wo to the man who shall provoke the King
For if, to-day, he smother close his wrath,
He harbors still the vengeance, and in time
Performs it. Answer, therefore, wilt thou save me?100
To whom Achilles, swiftest of the swift.
What thou hast learn'd in secret from the God
That speak, and boldly. By the son of Jove,
Apollo, whom thou, Calchas, seek'st in prayer
008 Made for the Danai, and who thy soul105
Fills with futurity, in all the host
The Grecian lives not, who while I shall breathe,
And see the light of day, shall in this camp
Oppress thee; no, not even if thou name
Him, Agamemnon, sovereign o'er us all.110
Then was the seer embolden'd, and he spake.
Nor vow nor hecatomb unpaid on us
He charges, but the wrong done to his priest
Whom Agamemnon slighted when he sought
His daughter's freedom, and his gifts refused.115
He is the cause. Apollo for his sake
Afflicts and will afflict us, neither end
Nor intermission of his heavy scourge
Granting, till unredeem'd, no price required,
The black-eyed maid be to her father sent,120
And a whole hecatomb in Chrysa bleed.
Then, not before, the God may be appeased.
He spake and sat; when Atreus' son arose,
The Hero Agamemnon, throned supreme.
Tempests of black resentment overcharged125
His heart, and indignation fired his eyes.
On Calchas lowering, him he first address'd.
Prophet of mischief! from whose tongue no note
Of grateful sound to me, was ever heard;
Ill tidings are thy joy, and tidings glad130
Thou tell'st not, or thy words come not to pass.
And now among the Danai thy dreams
Divulging, thou pretend'st the Archer-God
For his priest's sake, our enemy, because
I scorn'd his offer'd ransom of the maid135
Chryseis, more desirous far to bear
Her to my home, for that she charms me more
Than Clytemnestra, my own first espoused,
With whom, in disposition, feature, form,
Accomplishments, she may be well compared.140
Yet, being such, I will return her hence
If that she go be best. Perish myself --
009 But let the people of my charge be saved
Prepare ye, therefore, a reward for me,
And seek it instant. It were much unmeet145
That I alone of all the Argive host
Should want due recompense, whose former prize
Is elsewhere destined, as ye all perceive.
To whom Achilles, matchless in the race.
Atrides, glorious above all in rank,150
And as intent on gain as thou art great,
Whence shall the Grecians give a prize to thee?
The general stock is poor; the spoil of towns
Which we have taken, hath already passed
In distribution, and it were unjust155
To gather it from all the Greeks again.
But send thou back this Virgin to her God,
And when Jove's favor shall have given us Troy,
A threefold, fourfold share shall then be thine.
To whom the Sovereign of the host replied.160
Godlike Achilles, valiant as thou art,
Wouldst thou be subtle too? But me no fraud
Shall overreach, or art persuade, of thine.
Wouldst thou, that thou be recompensed, and I
Sit meekly down, defrauded of my due?165
And didst thou bid me yield her? Let the bold
Achaians give me competent amends,
Such as may please me, and it shall be well.
Else, if they give me none, I will command
Thy prize, the prize of Ajax, or the prize170
It may be of Ulysses to my tent,
And let the loser chafe. But this concern
Shall be adjusted at convenient time.
Come -- launch we now into the sacred deep
A bark with lusty rowers well supplied;175
Then put on board Chryseis, and with her
The sacrifice required. Go also one
High in authority, some counsellor,
Idomeneus, or Ajax, or thyself,
Thou most untractable of all mankind;180
010 And seek by rites of sacrifice and prayer
To appease Apollo on our host's behalf.
Achilles eyed him with a frown, and spake.
Ah! clothed with impudence as with a cloak,
And full of subtlety, who, thinkest thou -- 185
What Grecian here will serve thee, or for thee
Wage covert war, or open? Me thou know'st,
Troy never wronged; I came not to avenge
Harm done to me; no Trojan ever drove
My pastures, steeds or oxen took of mine,190
Or plunder'd of their fruits the golden fields
Of Phthia[13] the deep-soil'd. She lies remote,
And obstacles are numerous interposed,
Vale-darkening mountains, and the dashing sea.
No, [14]Shameless Wolf! For thy good pleasure's sake195
We came, and, [15]Face of flint! to avenge the wrongs
By Menelaus and thyself sustain'd,
On the offending Trojan -- service kind,
But lost on thee, regardless of it all.
And now -- What now? Thy threatening is to seize200
Thyself, the just requital of my toils,
My prize hard-earn'd, by common suffrage mine.
I never gain, what Trojan town soe'er
We ransack, half thy booty. The swift march
And furious onset -- these I largely reap,205
But, distribution made, thy lot exceeds
Mine far; while I, with any pittance pleased,
Bear to my ships the little that I win
After long battle, and account it much.
But I am gone, I and my sable barks210
(My wiser course) to Phthia, and I judge,
011 Scorn'd as I am, that thou shalt hardly glean
Without me, more than thou shalt soon consume.[16]
He ceased, and Agamemnon thus replied
Fly, and fly now; if in thy soul thou feel215
Such ardor of desire to go -- begone!
I woo thee not to stay; stay not an hour
On my behalf, for I have others here
Who will respect me more, and above all
All-judging Jove. There is not in the host220
King or commander whom I hate as thee,
For all thy pleasure is in strife and blood,
And at all times; yet valor is no ground
Whereon to boast, it is the gift of Heaven
Go, get ye back to Phthia, thou and thine!225
There rule thy Myrmidons.[17] I need not thee,
Nor heed thy wrath a jot. But this I say,
Sure as Apollo takes my lovely prize
Chryseis, and I shall return her home
In mine own bark, and with my proper crew,230
So sure the fair Briseis shall be mine.
I shall demand her even at thy tent.
So shalt thou well be taught, how high in power
I soar above thy pitch, and none shall dare
Attempt, thenceforth, comparison with me.235
He ended, and the big, disdainful heart
Throbbed of Achilles; racking doubt ensued
And sore perplex'd him, whether forcing wide
A passage through them, with his blade unsheathed
To lay Atrides breathless at his foot,240
012 Or to command his stormy spirit down.
So doubted he, and undecided yet
Stood drawing forth his falchion huge; when lo!
Down sent by Juno, to whom both alike
Were dear, and who alike watched over both,245
Pallas descended. At his back she stood
To none apparent, save himself alone,
And seized his golden locks. Startled, he turned,
And instant knew Minerva. Flashed her eyes
Terrific;[18] whom with accents on the wing250
Of haste, incontinent he questioned thus.
Daughter of Jove, why comest thou? that thyself
May'st witness these affronts which I endure
From Agamemnon? Surely as I speak,
This moment, for his arrogance, he dies.255
To whom the blue-eyed Deity. From heaven
Mine errand is, to sooth, if thou wilt hear,
Thine anger. Juno the white-arm'd alike
To him and thee propitious, bade me down:
Restrain thy wrath. Draw not thy falchion forth.260
Retort, and sharply, and let that suffice.
For I foretell thee true. Thou shalt receive,
Some future day, thrice told, thy present loss
For this day's wrong. Cease, therefore, and be still.
To whom Achilles. Goddess, although much265
Exasperate, I dare not disregard
Thy word, which to obey is always best.[19]
Who hears the Gods, the Gods hear also him.
He said; and on his silver hilt the force
Of his broad hand impressing, sent the blade270
Home to its rest, nor would the counsel scorn
013 Of Pallas. She to heaven well-pleased return'd,
And in the mansion of Jove AEgis[20]-armed
Arriving, mingled with her kindred Gods.
But though from violence, yet not from words275
Abstained Achilles, but with bitter taunt
Opprobrious, his antagonist reproached.
Oh charged with wine, in steadfastness of face
Dog unabashed, and yet at heart a deer!
Thou never, when the troops have taken arms,280
Hast dared to take thine also; never thou
Associate with Achaia's Chiefs, to form
The secret ambush.[21] No. The sound of war
Is as the voice of destiny to thee.
Doubtless the course is safer far, to range285
Our numerous host, and if a man have dared
Dispute thy will, to rob him of his prize.
King! over whom? Women and spiritless --
Whom therefore thou devourest; else themselves
Would stop that mouth that it should scoff no more.290
But hearken. I shall swear a solemn oath.
By this same sceptre,[22] which shall never bud,
Nor boughs bring forth as once, which having left
Its stock on the high mountains, at what time
The woodman's axe lopped off its foliage green,295
And stript its bark, shall never grow again;
Which now the judges of Achaia bear,
014 Who under Jove, stand guardians of the laws,
By this I swear (mark thou the sacred oath)
Time shall be, when Achilles shall be missed;300
When all shall want him, and thyself the power
To help the Achaians, whatsoe'er thy will;
When Hector at your heels shall mow you down:
The Hero-slaughtering Hector! Then thy soul,
Vexation-stung, shall tear thee with remorse,305
That thou hast scorn'd, as he were nothing worth,
A Chief, the soul and bulwark of your cause.
So saying, he cast his sceptre on the ground
Studded with gold, and sat. On the other side
The son of Atreus all impassion'd stood,310
When the harmonious orator arose
Nestor, the Pylian oracle, whose lips
Dropped eloquence -- the honey not so sweet.
Two generations past of mortals born
In Pylus, coetaneous with himself,315
He govern'd now the third -- amid them all
He stood, and thus, benevolent, began.
Ah! what calamity hath fall'n on Greece!
Now Priam and his sons may well exult,
Now all in Ilium shall have joy of heart320
Abundant, hearing of this broil, the prime
Of Greece between, in council and in arms.
But be persuaded; ye are younger both
Than I, and I was conversant of old
With Princes your superiors, yet from them325
No disrespect at any time received.
Their equals saw I never; never shall;
Exadius, Coeneus, and the Godlike son
Of AEgeus, mighty Theseus; men renown'd
For force superior to the race of man,330
Brave Chiefs they were, and with brave foes they fought,
With the rude dwellers on the mountain-heights
The Centaurs,[23] whom with havoc such as fame
015 Shall never cease to celebrate, they slew.
With these men I consorted erst, what time335
From Pylus, though a land from theirs remote,
They called me forth, and such as was my strength,
With all that strength I served them. Who is he?
What Prince or Chief of the degenerate race
Now seen on earth who might with these compare?340
Yet even these would listen and conform
To my advice in consultation given,
Which hear ye also; for compliance proves
Oft times the safer and the manlier course.
Thou, Agamemnon! valiant as thou art,345
Seize not the maid, his portion from the Greeks,
But leave her his; nor thou, Achilles, strive
With our imperial Chief; for never King
Had equal honor at the hands of Jove
With Agamemnon, or was throned so high.350
Say thou art stronger, and art Goddess-born,
How then? His territory passes thine,
And he is Lord of thousands more than thou.
Cease, therefore, Agamemnon; calm thy wrath;
And it shall be mine office to entreat355
Achilles also to a calm, whose might
The chief munition is of all our host.
To whom the sovereign of the Greeks replied,
The son of Atreus. Thou hast spoken well,
Old Chief, and wisely. But this wrangler here -- 360
Nought will suffice him but the highest place:
He must control us all, reign over all,
Dictate to all; but he shall find at least
One here, disposed to question his commands.
If the eternal Gods have made him brave,365
Derives he thence a privilege to rail?
Whom thus Achilles interrupted fierce.
Could I be found so abject as to take
The measure of my doings at thy lips,
Well might they call me coward through the camp,370
A vassal, and a fellow of no worth.
016 Give law to others. Think not to control
Me, subject to thy proud commands no more.
Hear yet again! And weigh what thou shalt hear.
I will not strive with thee in such a cause,375
Nor yet with any man; I scorn to fight
For her, whom having given, ye take away.
But I have other precious things on board;
Of those take none away without my leave.
Or if it please thee, put me to the proof380
Before this whole assembly, and my spear
Shall stream that moment, purpled with thy blood.
Thus they long time in opposition fierce
Maintained the war of words; and now, at length,
(The grand consult dissolved,) Achilles walked385
(Patroclus and the Myrmidons his steps
Attending) to his camp and to his fleet.
But Agamemnon order'd forth a bark,
A swift one, manned with twice ten lusty rowers;
He sent on board the Hecatomb:[24] he placed390
Chryseis with the blooming cheeks, himself,
And to Ulysses gave the freight in charge.
So all embarked, and plow'd their watery way.
Atrides, next, bade purify the host;
The host was purified, as he enjoin'd,395
And the ablution cast into the sea.
Then to Apollo, on the shore they slew,
Of the untillable and barren deep,
Whole Hecatombs of bulls and goats, whose steam
Slowly in smoky volumes climbed the skies.400
Thus was the camp employed; nor ceased the while
The son of Atreus from his threats denounced
At first against Achilles, but command
Gave to Talthybius and Eurybates
His heralds, ever faithful to his will.405
Haste -- Seek ye both the tent of Peleus' son
Achilles. Thence lead hither by the hand
017 Blooming Briseis, whom if he withhold,
Not her alone, but other spoil myself
Will take in person -- He shall rue the hour.410
With such harsh message charged he them dismissed
They, sad and slow, beside the barren waste
Of Ocean, to the galleys and the tents
Moved of the Myrmidons. Him there they found
Beneath the shadow of his bark reclined,415
Nor glad at their approach. Trembling they stood,
In presence of the royal Chief, awe-struck,
Nor questioned him or spake. He not the less
Knew well their embassy, and thus began.
Ye heralds, messengers of Gods and men,420
Hail, and draw near! I bid you welcome both.
I blame not you; the fault is his alone
Who sends you to conduct the damsel hence
Briseis. Go, Patroclus, generous friend!
Lead forth, and to their guidance give the maid.425
But be themselves my witnesses before
The blessed Gods, before mankind, before
The ruthless king, should want of me be felt
To save the host from havoc[25] -- Oh, his thoughts
Are madness all; intelligence or skill,430
Forecast or retrospect, how best the camp
May be secured from inroad, none hath he.
He ended, nor Patroclus disobey'd,
But leading beautiful Briseis forth
Into their guidance gave her; loth she went435
From whom she loved, and looking oft behind.
Then wept Achilles, and apart from all,
With eyes directed to the gloomy Deep
And arms outstretch'd, his mother suppliant sought.
Since, mother, though ordain'd so soon to die,440
I am thy son, I might with cause expect
Some honor at the Thunderer's hands, but none
To me he shows, whom Agamemnon, Chief
018 Of the Achaians, hath himself disgraced,
Seizing by violence my just reward.445
So prayed he weeping, whom his mother heard
Within the gulfs of Ocean where she sat
Beside her ancient sire. From the gray flood
Ascending sudden, like a mist she came,
Sat down before him, stroked his face, and said.450
Why weeps my son? and what is thy distress?
Hide not a sorrow that I wish to share.
To whom Achilles, sighing deep, replied.
Why tell thee woes to thee already known?
At Thebes, Eetion's city we arrived,455
Smote, sack'd it, and brought all the spoil away.
Just distribution made among the Greeks,
The son of Atreus for his lot received
Blooming Chryseis. Her, Apollo's priest
Old Chryses followed to Achaia's camp,460
That he might loose his daughter. Ransom rich
He brought, and in his hands the hallow'd wreath
And golden sceptre of the Archer God
Apollo, bore; to the whole Grecian host,
But chiefly to the foremost in command465
He sued, the sons of Atreus; then, the rest
All recommended reverence of the Seer,
And prompt acceptance of his costly gifts.
But Agamemnon might not so be pleased,
Who gave him rude dismission; he in wrath470
Returning, prayed, whose prayer Apollo heard,
For much he loved him. A pestiferous shaft
He instant shot into the Grecian host,
And heap'd the people died. His arrows swept
The whole wide camp of Greece, till at the last475
A Seer, by Phoebus taught, explain'd the cause.
I first advised propitiation. Rage
Fired Agamemnon. Rising, he denounced
Vengeance, and hath fulfilled it. She, in truth,
Is gone to Chrysa, and with her we send480
Propitiation also to the King
019 Shaft-arm'd Apollo. But my beauteous prize
Briseis, mine by the award of all,
His heralds, at this moment, lead away.
But thou, wherein thou canst, aid thy own son!485
Haste hence to Heaven, and if thy word or deed
Hath ever gratified the heart of Jove,
With earnest suit press him on my behalf.
For I, not seldom, in my father's hall
Have heard thee boasting, how when once the Gods,490
With Juno, Neptune, Pallas at their head,
Conspired to bind the Thunderer, thou didst loose
His bands, O Goddess! calling to his aid
The Hundred-handed warrior, by the Gods
Briareus, but by men, AEgeon named.[26]495
For he in prowess and in might surpassed
020 His father Neptune, who, enthroned sublime,
Sits second only to Saturnian Jove,
Elate with glory and joy. Him all the Gods
Fearing from that bold enterprise abstained.500
Now, therefore, of these things reminding Jove,
Embrace his knees; entreat him that he give
The host of Troy his succor, and shut fast
The routed Grecians, prisoners in the fleet,
That all may find much solace[27] in their King,505
And that the mighty sovereign o'er them all,
Their Agamemnon, may himself be taught
His rashness, who hath thus dishonor'd foul
The life itself, and bulwark of his cause.
To him, with streaming eyes, Thetis replied.510
Born as thou wast to sorrow, ah, my son!
Why have I rear'd thee! Would that without tears,
Or cause for tears (transient as is thy life,
A little span) thy days might pass at Troy!
But short and sorrowful the fates ordain515
Thy life, peculiar trouble must be thine,
Whom, therefore, oh that I had never borne!
But seeking the Olympian hill snow-crown'd,
I will myself plead for thee in the ear
Of Jove, the Thunderer. Meantime at thy fleet520
Abiding, let thy wrath against the Greeks
Still burn, and altogether cease from war.
For to the banks of the Oceanus,[28]
Where AEthiopia holds a feast to Jove,[29]
021 He journey'd yesterday, with whom the Gods525
Went also, and the twelfth day brings them home.
Then will I to his brazen-floor'd abode,
That I may clasp his knees, and much misdeem
Of my endeavor, or my prayer shall speed.
So saying, she went; but him she left enraged530
For fair Briseis' sake, forced from his arms
By stress of power. Meantime Ulysses came
To Chrysa with the Hecatomb in charge.
Arrived within the haven[30] deep, their sails
Furling, they stowed them in the bark below.535
Then by its tackle lowering swift the mast
Into its crutch, they briskly push'd to land,
Heaved anchors out, and moor'd the vessel fast.
Forth came the mariners, and trod the beach;
Forth came the victims of Apollo next,540
And, last, Chryseis. Her Ulysses led
Toward the altar, gave her to the arms
Of her own father, and him thus address'd.
O Chryses! Agamemnon, King of men,
Hath sent thy daughter home, with whom we bring545
A Hecatomb on all our host's behalf
To Phoebus, hoping to appease the God
022 By whose dread shafts the Argives now expire.
So saying, he gave her to him, who with joy
Received his daughter. Then, before the shrine550
Magnificent in order due they ranged
The noble Hecatomb.[31] Each laved his hands
And took the salted meal, and Chryses made
His fervent prayer with hands upraised on high.
God of the silver bow, who with thy power555
Encirclest Chrysa, and who reign'st supreme
In Tenedos, and Cilla the divine!
Thou prov'dst propitious to my first request,
Hast honor'd me, and punish'd sore the Greeks;
Hear yet thy servant's prayer; take from their host560
At once the loathsome pestilence away!
So Chryses prayed, whom Phoebus heard well-pleased;
Then prayed the Grecians also, and with meal
Sprinkling the victims, their retracted necks
First pierced, then flay'd them; the disjointed thighs565
They, next, invested with the double caul,
Which with crude slices thin they overspread.
The priest burned incense, and libation poured
Large on the hissing brands, while, him beside,
Busy with spit and prong, stood many a youth570
Trained to the task. The thighs with fire consumed,
They gave to each his portion of the maw,
Then slashed the remnant, pierced it with the spits,
And managing with culinary skill
The roast, withdrew it from the spits again.575
Their whole task thus accomplish'd, and the board
023 Set forth, they feasted, and were all sufficed.
When neither hunger more nor thirst remained
Unsatisfied, boys crown'd the beakers high
With wine delicious, and from right to left580
Distributing the cups, served every guest.
Thenceforth the youths of the Achaian race
To song propitiatory gave the day,
Paeans[32] to Phoebus, Archer of the skies,
Chaunting melodious. Pleased, Apollo heard.585
But, when, the sun descending, darkness fell,
They on the beach beside their hawsers slept;
And, when the day-spring's daughter rosy-palm'd
Aurora look'd abroad, then back they steer'd
To the vast camp. Fair wind, and blowing fresh,590
Apollo sent them; quick they rear'd the mast,
Then spread the unsullied canvas to the gale,
And the wind filled it. Roared the sable flood
Around the bark, that ever as she went
Dash'd wide the brine, and scudded swift away.595
Thus reaching soon the spacious camp of Greece,
Their galley they updrew sheer o'er the sands
From the rude surge remote, then propp'd her sides
With scantlings long,[33] and sought their several tents.
But Peleus' noble son, the speed-renown'd600
Achilles, he, his well-built bark beside,
Consumed his hours, nor would in council more,
Where wise men win distinction, or in fight
Appear, to sorrow and heart-withering wo
Abandon'd; though for battle, ardent, still605
He panted, and the shout-resounding field.
But when the twelfth fair morrow streak'd the East,
024 Then all the everlasting Gods to Heaven
Resorted, with the Thunderer at their head,
And Thetis, not unmindful of her son,610
Prom the salt flood emerged, seeking betimes
Olympus and the boundless fields of heaven.
High, on the topmost eminence sublime
Of the deep-fork'd Olympian she perceived
The Thunderer seated, from the Gods apart.615
She sat before him, clasp'd with her left hand
His knees, her right beneath his chin she placed,
And thus the King, Saturnian Jove, implored.
Father of all, by all that I have done
Or said that ever pleased thee, grant my suit.620
Exalt my son, by destiny short-lived
Beyond the lot of others. Him with shame
The King of men hath overwhelm'd, by force
Usurping his just meed; thou, therefore, Jove,
Supreme in wisdom, honor him, and give625
Success to Troy, till all Achaia's sons
Shall yield him honor more than he hath lost!
She spake, to whom the Thunderer nought replied,
But silent sat long time. She, as her hand
Had grown there, still importunate, his knees630
Clasp'd as at first, and thus her suit renew'd.[34]
Or grant my prayer, and ratify the grant,
Or send me hence (for thou hast none to fear)
Plainly refused; that I may know and feel
By how much I am least of all in heaven.635
To whom the cloud-assembler at the last
Spake, deep-distress'd. Hard task and full of strife
Thou hast enjoined me; Juno will not spare
For gibe and taunt injurious, whose complaint
Sounds daily in the ears of all the Gods,640
That I assist the Trojans; but depart,
Lest she observe thee; my concern shall be
How best I may perform thy full desire.
025 And to assure thee more, I give the sign
Indubitable, which all fear expels645
At once from heavenly minds. Nought, so confirmed,
May, after, be reversed or render'd vain.
He ceased, and under his dark brows the nod
Vouchsafed of confirmation. All around
The Sovereign's everlasting head his curls650
Ambrosial shook,[35] and the huge mountain reeled.
Their conference closed, they parted. She, at once,
From bright Olympus plunged into the flood
Profound, and Jove to his own courts withdrew.
Together all the Gods, at his approach,655
Uprose; none sat expectant till he came,
But all advanced to meet the Eternal Sire.
So on his throne he sat. Nor Juno him
Not understood; she, watchful, had observed,
In consultation close with Jove engaged660
Thetis, bright-footed daughter of the deep,
And keen the son of Saturn thus reproved.
Shrewd as thou art, who now hath had thine ear?
Thy joy is ever such, from me apart
To plan and plot clandestine, and thy thoughts,665
Think what thou may'st, are always barred to me.
To whom the father, thus, of heaven and earth.
Expect not, Juno, that thou shalt partake
My counsels at all times, which oft in height
And depth, thy comprehension far exceed,670
Jove's consort as thou art. When aught occurs
Meet for thine ear, to none will I impart
Of Gods or men more free than to thyself.
But for my secret thoughts, which I withhold
From all in heaven beside, them search not thou675
With irksome curiosity and vain.
026 Him answer'd then the Goddess ample-eyed.[36]
What word hath passed thy lips, Saturnian Jove,
Thou most severe! I never search thy thoughts,
Nor the serenity of thy profound680
Intentions trouble; they are safe from me:
But now there seems a cause. Deeply I dread
Lest Thetis, silver-footed daughter fair
Of Ocean's hoary Sovereign, here arrived
At early dawn to practise on thee, Jove!685
I noticed her a suitress at thy knees,
And much misdeem or promise-bound thou stand'st
To Thetis past recall, to exalt her son,
And Greeks to slaughter thousands at the ships.
To whom the cloud-assembler God, incensed.690
Ah subtle! ever teeming with surmise,
And fathomer of my concealed designs,
Thy toil is vain, or (which is worse for thee,)
Shall but estrange thee from mine heart the more.
And be it as thou sayest, -- I am well pleased695
That so it should be. Be advised, desist,
Hold thou thy peace. Else, if my glorious hands
Once reach thee, the Olympian Powers combined
To rescue thee, shall interfere in vain.
He said, -- whom Juno, awful Goddess, heard700
Appall'd, and mute submitted to his will.
But through the courts of Jove the heavenly Powers
All felt displeasure; when to them arose
Vulcan, illustrious artist, who with speech
Conciliatory interposed to sooth705
His white-armed mother Juno, Goddess dread.
Hard doom is ours, and not to be endured,
027 If feast and merriment must pause in heaven
While ye such clamor raise tumultuous here
For man's unworthy sake: yet thus we speed710
Ever, when evil overpoises good.
But I exhort my mother, though herself
Already warn'd, that meekly she submit
To Jove our father, lest our father chide
More roughly, and confusion mar the feast.715
For the Olympian Thunderer could with ease
Us from our thrones precipitate, so far
He reigns to all superior. Seek to assuage
His anger therefore; so shall he with smiles
Cheer thee, nor thee alone, but all in heaven.720
So Vulcan, and, upstarting, placed a cup
Full-charged between his mother's hands, and said,
My mother, be advised, and, though aggrieved,
Yet patient; lest I see thee whom I love
So dear, with stripes chastised before my face,725
Willing, but impotent to give thee aid.[37]
Who can resist the Thunderer? Me, when once
I flew to save thee, by the foot he seized
And hurl'd me through the portal of the skies.
"From morn to eve I fell, a summer's day,"730
And dropped, at last, in Lemnos. There half-dead
The Sintians found me, and with succor prompt
And hospitable, entertained me fallen.
So He; then Juno smiled, Goddess white-arm'd,
And smiling still, from his unwonted hand[38]735
Received the goblet. He from right to left
Rich nectar from the beaker drawn, alert
Distributed to all the powers divine.
028 Heaven rang with laughter inextinguishable
Peal after peal, such pleasure all conceived740
At sight of Vulcan in his new employ.
So spent they in festivity the day,
And all were cheered; nor was Apollo's harp
Silent, nor did the Muses spare to add
Responsive melody of vocal sweets.745
But when the sun's bright orb had now declined,
Each to his mansion, wheresoever built
By the lame matchless Architect, withdrew.[39]
Jove also, kindler of the fires of heaven,
His couch ascending as at other times750
When gentle sleep approach'd him, slept serene,
With golden-sceptred Juno at his side.
"""


# Excerpt from "The Adventures of Huckleberry Finn" by Mark Twain.
# Text from project Gutenberg, public domain.
text2_huckleberry_finn = b"""
CHAPTER I.

YOU don't know about me without you have read a book by the name of The
Adventures of Tom Sawyer; but that ain't no matter.  That book was made
by Mr. Mark Twain, and he told the truth, mainly.  There was things
which he stretched, but mainly he told the truth.  That is nothing.  I
never seen anybody but lied one time or another, without it was Aunt
Polly, or the widow, or maybe Mary.  Aunt Polly--Tom's Aunt Polly, she
is--and Mary, and the Widow Douglas is all told about in that book, which
is mostly a true book, with some stretchers, as I said before.

Now the way that the book winds up is this:  Tom and me found the money
that the robbers hid in the cave, and it made us rich.  We got six
thousand dollars apiece--all gold.  It was an awful sight of money when
it was piled up.  Well, Judge Thatcher he took it and put it out
at interest, and it fetched us a dollar a day apiece all the year
round--more than a body could tell what to do with.  The Widow Douglas
she took me for her son, and allowed she would sivilize me; but it was
rough living in the house all the time, considering how dismal regular
and decent the widow was in all her ways; and so when I couldn't stand
it no longer I lit out.  I got into my old rags and my sugar-hogshead
again, and was free and satisfied.  But Tom Sawyer he hunted me up and
said he was going to start a band of robbers, and I might join if I
would go back to the widow and be respectable.  So I went back.

The widow she cried over me, and called me a poor lost lamb, and she
called me a lot of other names, too, but she never meant no harm by
it. She put me in them new clothes again, and I couldn't do nothing but
sweat and sweat, and feel all cramped up.  Well, then, the old thing
commenced again.  The widow rung a bell for supper, and you had to come
to time. When you got to the table you couldn't go right to eating, but
you had to wait for the widow to tuck down her head and grumble a little
over the victuals, though there warn't really anything the matter with
them,--that is, nothing only everything was cooked by itself.  In a
barrel of odds and ends it is different; things get mixed up, and the
juice kind of swaps around, and the things go better.

After supper she got out her book and learned me about Moses and the
Bulrushers, and I was in a sweat to find out all about him; but by and
by she let it out that Moses had been dead a considerable long time; so
then I didn't care no more about him, because I don't take no stock in
dead people.

Pretty soon I wanted to smoke, and asked the widow to let me.  But she
wouldn't.  She said it was a mean practice and wasn't clean, and I must
try to not do it any more.  That is just the way with some people.  They
get down on a thing when they don't know nothing about it.  Here she was
a-bothering about Moses, which was no kin to her, and no use to anybody,
being gone, you see, yet finding a power of fault with me for doing a
thing that had some good in it.  And she took snuff, too; of course that
was all right, because she done it herself.

Her sister, Miss Watson, a tolerable slim old maid, with goggles on,
had just come to live with her, and took a set at me now with a
spelling-book. She worked me middling hard for about an hour, and then
the widow made her ease up.  I couldn't stood it much longer.  Then for
an hour it was deadly dull, and I was fidgety.  Miss Watson would say,
"Don't put your feet up there, Huckleberry;" and "Don't scrunch up
like that, Huckleberry--set up straight;" and pretty soon she would
say, "Don't gap and stretch like that, Huckleberry--why don't you try to
behave?"  Then she told me all about the bad place, and I said I wished
I was there. She got mad then, but I didn't mean no harm.  All I wanted
was to go somewheres; all I wanted was a change, I warn't particular.
 She said it was wicked to say what I said; said she wouldn't say it for
the whole world; she was going to live so as to go to the good place.
 Well, I couldn't see no advantage in going where she was going, so I
made up my mind I wouldn't try for it.  But I never said so, because it
would only make trouble, and wouldn't do no good.

Now she had got a start, and she went on and told me all about the good
place.  She said all a body would have to do there was to go around all
day long with a harp and sing, forever and ever.  So I didn't think
much of it. But I never said so.  I asked her if she reckoned Tom Sawyer
would go there, and she said not by a considerable sight.  I was glad
about that, because I wanted him and me to be together.

Miss Watson she kept pecking at me, and it got tiresome and lonesome.
 By and by they fetched the niggers in and had prayers, and then
everybody was off to bed.  I went up to my room with a piece of candle,
and put it on the table.  Then I set down in a chair by the window and
tried to think of something cheerful, but it warn't no use.  I felt
so lonesome I most wished I was dead.  The stars were shining, and the
leaves rustled in the woods ever so mournful; and I heard an owl, away
off, who-whooing about somebody that was dead, and a whippowill and a
dog crying about somebody that was going to die; and the wind was trying
to whisper something to me, and I couldn't make out what it was, and so
it made the cold shivers run over me. Then away out in the woods I heard
that kind of a sound that a ghost makes when it wants to tell about
something that's on its mind and can't make itself understood, and so
can't rest easy in its grave, and has to go about that way every night
grieving.  I got so down-hearted and scared I did wish I had some
company.  Pretty soon a spider went crawling up my shoulder, and I
flipped it off and it lit in the candle; and before I could budge it
was all shriveled up.  I didn't need anybody to tell me that that was
an awful bad sign and would fetch me some bad luck, so I was scared
and most shook the clothes off of me. I got up and turned around in my
tracks three times and crossed my breast every time; and then I tied
up a little lock of my hair with a thread to keep witches away.  But
I hadn't no confidence.  You do that when you've lost a horseshoe that
you've found, instead of nailing it up over the door, but I hadn't ever
heard anybody say it was any way to keep off bad luck when you'd killed
a spider.

I set down again, a-shaking all over, and got out my pipe for a smoke;
for the house was all as still as death now, and so the widow wouldn't
know. Well, after a long time I heard the clock away off in the town
go boom--boom--boom--twelve licks; and all still again--stiller than
ever. Pretty soon I heard a twig snap down in the dark amongst the
trees--something was a stirring.  I set still and listened.  Directly I
could just barely hear a "me-yow! me-yow!" down there.  That was good!
 Says I, "me-yow! me-yow!" as soft as I could, and then I put out the
light and scrambled out of the window on to the shed.  Then I slipped
down to the ground and crawled in among the trees, and, sure enough,
there was Tom Sawyer waiting for me.


CHAPTER II.

WE went tiptoeing along a path amongst the trees back towards the end of
the widow's garden, stooping down so as the branches wouldn't scrape our
heads. When we was passing by the kitchen I fell over a root and made
a noise.  We scrouched down and laid still.  Miss Watson's big nigger,
named Jim, was setting in the kitchen door; we could see him pretty
clear, because there was a light behind him.  He got up and stretched
his neck out about a minute, listening.  Then he says:

"Who dah?"

He listened some more; then he come tiptoeing down and stood right
between us; we could a touched him, nearly.  Well, likely it was
minutes and minutes that there warn't a sound, and we all there so close
together.  There was a place on my ankle that got to itching, but I
dasn't scratch it; and then my ear begun to itch; and next my back,
right between my shoulders.  Seemed like I'd die if I couldn't scratch.
 Well, I've noticed that thing plenty times since.  If you are with
the quality, or at a funeral, or trying to go to sleep when you ain't
sleepy--if you are anywheres where it won't do for you to scratch, why
you will itch all over in upwards of a thousand places. Pretty soon Jim
says:

"Say, who is you?  Whar is you?  Dog my cats ef I didn' hear sumf'n.
Well, I know what I's gwyne to do:  I's gwyne to set down here and
listen tell I hears it agin."

So he set down on the ground betwixt me and Tom.  He leaned his back up
against a tree, and stretched his legs out till one of them most touched
one of mine.  My nose begun to itch.  It itched till the tears come into
my eyes.  But I dasn't scratch.  Then it begun to itch on the inside.
Next I got to itching underneath.  I didn't know how I was going to set
still. This miserableness went on as much as six or seven minutes; but
it seemed a sight longer than that.  I was itching in eleven different
places now.  I reckoned I couldn't stand it more'n a minute longer,
but I set my teeth hard and got ready to try.  Just then Jim begun
to breathe heavy; next he begun to snore--and then I was pretty soon
comfortable again.

Tom he made a sign to me--kind of a little noise with his mouth--and we
went creeping away on our hands and knees.  When we was ten foot off Tom
whispered to me, and wanted to tie Jim to the tree for fun.  But I said
no; he might wake and make a disturbance, and then they'd find out I
warn't in. Then Tom said he hadn't got candles enough, and he would slip
in the kitchen and get some more.  I didn't want him to try.  I said Jim
might wake up and come.  But Tom wanted to resk it; so we slid in there
and got three candles, and Tom laid five cents on the table for pay.
Then we got out, and I was in a sweat to get away; but nothing would do
Tom but he must crawl to where Jim was, on his hands and knees, and play
something on him.  I waited, and it seemed a good while, everything was
so still and lonesome.

As soon as Tom was back we cut along the path, around the garden fence,
and by and by fetched up on the steep top of the hill the other side of
the house.  Tom said he slipped Jim's hat off of his head and hung it
on a limb right over him, and Jim stirred a little, but he didn't wake.
Afterwards Jim said the witches be witched him and put him in a trance,
and rode him all over the State, and then set him under the trees again,
and hung his hat on a limb to show who done it.  And next time Jim told
it he said they rode him down to New Orleans; and, after that, every
time he told it he spread it more and more, till by and by he said they
rode him all over the world, and tired him most to death, and his back
was all over saddle-boils.  Jim was monstrous proud about it, and he
got so he wouldn't hardly notice the other niggers.  Niggers would come
miles to hear Jim tell about it, and he was more looked up to than any
nigger in that country.  Strange niggers would stand with their mouths
open and look him all over, same as if he was a wonder.  Niggers is
always talking about witches in the dark by the kitchen fire; but
whenever one was talking and letting on to know all about such things,
Jim would happen in and say, "Hm!  What you know 'bout witches?" and
that nigger was corked up and had to take a back seat.  Jim always kept
that five-center piece round his neck with a string, and said it was a
charm the devil give to him with his own hands, and told him he could
cure anybody with it and fetch witches whenever he wanted to just by
saying something to it; but he never told what it was he said to it.
 Niggers would come from all around there and give Jim anything they
had, just for a sight of that five-center piece; but they wouldn't touch
it, because the devil had had his hands on it.  Jim was most ruined for
a servant, because he got stuck up on account of having seen the devil
and been rode by witches.

Well, when Tom and me got to the edge of the hilltop we looked away down
into the village and could see three or four lights twinkling, where
there was sick folks, maybe; and the stars over us was sparkling ever
so fine; and down by the village was the river, a whole mile broad, and
awful still and grand.  We went down the hill and found Jo Harper and
Ben Rogers, and two or three more of the boys, hid in the old tanyard.
 So we unhitched a skiff and pulled down the river two mile and a half,
to the big scar on the hillside, and went ashore.

We went to a clump of bushes, and Tom made everybody swear to keep the
secret, and then showed them a hole in the hill, right in the thickest
part of the bushes.  Then we lit the candles, and crawled in on our
hands and knees.  We went about two hundred yards, and then the cave
opened up. Tom poked about amongst the passages, and pretty soon ducked
under a wall where you wouldn't a noticed that there was a hole.  We
went along a narrow place and got into a kind of room, all damp and
sweaty and cold, and there we stopped.  Tom says:

"Now, we'll start this band of robbers and call it Tom Sawyer's Gang.
Everybody that wants to join has got to take an oath, and write his name
in blood."

Everybody was willing.  So Tom got out a sheet of paper that he had
wrote the oath on, and read it.  It swore every boy to stick to the
band, and never tell any of the secrets; and if anybody done anything to
any boy in the band, whichever boy was ordered to kill that person and
his family must do it, and he mustn't eat and he mustn't sleep till he
had killed them and hacked a cross in their breasts, which was the sign
of the band. And nobody that didn't belong to the band could use that
mark, and if he did he must be sued; and if he done it again he must be
killed.  And if anybody that belonged to the band told the secrets, he
must have his throat cut, and then have his carcass burnt up and the
ashes scattered all around, and his name blotted off of the list with
blood and never mentioned again by the gang, but have a curse put on it
and be forgot forever.

Everybody said it was a real beautiful oath, and asked Tom if he got
it out of his own head.  He said, some of it, but the rest was out of
pirate-books and robber-books, and every gang that was high-toned had
it.

Some thought it would be good to kill the _families_ of boys that told
the secrets.  Tom said it was a good idea, so he took a pencil and wrote
it in. Then Ben Rogers says:

"Here's Huck Finn, he hain't got no family; what you going to do 'bout
him?"

"Well, hain't he got a father?" says Tom Sawyer.

"Yes, he's got a father, but you can't never find him these days.  He
used to lay drunk with the hogs in the tanyard, but he hain't been seen
in these parts for a year or more."

They talked it over, and they was going to rule me out, because they
said every boy must have a family or somebody to kill, or else it
wouldn't be fair and square for the others.  Well, nobody could think of
anything to do--everybody was stumped, and set still.  I was most ready
to cry; but all at once I thought of a way, and so I offered them Miss
Watson--they could kill her.  Everybody said:

"Oh, she'll do.  That's all right.  Huck can come in."

Then they all stuck a pin in their fingers to get blood to sign with,
and I made my mark on the paper.

"Now," says Ben Rogers, "what's the line of business of this Gang?"

"Nothing only robbery and murder," Tom said.

"But who are we going to rob?--houses, or cattle, or--"

"Stuff! stealing cattle and such things ain't robbery; it's burglary,"
 says Tom Sawyer.  "We ain't burglars.  That ain't no sort of style.  We
are highwaymen.  We stop stages and carriages on the road, with masks
on, and kill the people and take their watches and money."

"Must we always kill the people?"

"Oh, certainly.  It's best.  Some authorities think different, but
mostly it's considered best to kill them--except some that you bring to
the cave here, and keep them till they're ransomed."

"Ransomed?  What's that?"

"I don't know.  But that's what they do.  I've seen it in books; and so
of course that's what we've got to do."

"But how can we do it if we don't know what it is?"

"Why, blame it all, we've _got_ to do it.  Don't I tell you it's in the
books?  Do you want to go to doing different from what's in the books,
and get things all muddled up?"

"Oh, that's all very fine to _say_, Tom Sawyer, but how in the nation
are these fellows going to be ransomed if we don't know how to do it
to them?--that's the thing I want to get at.  Now, what do you reckon it
is?"

"Well, I don't know.  But per'aps if we keep them till they're ransomed,
it means that we keep them till they're dead."

"Now, that's something _like_.  That'll answer.  Why couldn't you said
that before?  We'll keep them till they're ransomed to death; and a
bothersome lot they'll be, too--eating up everything, and always trying
to get loose."

"How you talk, Ben Rogers.  How can they get loose when there's a guard
over them, ready to shoot them down if they move a peg?"

"A guard!  Well, that _is_ good.  So somebody's got to set up all night
and never get any sleep, just so as to watch them.  I think that's
foolishness. Why can't a body take a club and ransom them as soon as
they get here?"

"Because it ain't in the books so--that's why.  Now, Ben Rogers, do you
want to do things regular, or don't you?--that's the idea.  Don't you
reckon that the people that made the books knows what's the correct
thing to do?  Do you reckon _you_ can learn 'em anything?  Not by a good
deal. No, sir, we'll just go on and ransom them in the regular way."

"All right.  I don't mind; but I say it's a fool way, anyhow.  Say, do
we kill the women, too?"

"Well, Ben Rogers, if I was as ignorant as you I wouldn't let on.  Kill
the women?  No; nobody ever saw anything in the books like that.  You
fetch them to the cave, and you're always as polite as pie to them;
and by and by they fall in love with you, and never want to go home any
more."

"Well, if that's the way I'm agreed, but I don't take no stock in it.
Mighty soon we'll have the cave so cluttered up with women, and fellows
waiting to be ransomed, that there won't be no place for the robbers.
But go ahead, I ain't got nothing to say."

Little Tommy Barnes was asleep now, and when they waked him up he was
scared, and cried, and said he wanted to go home to his ma, and didn't
want to be a robber any more.

So they all made fun of him, and called him cry-baby, and that made him
mad, and he said he would go straight and tell all the secrets.  But
Tom give him five cents to keep quiet, and said we would all go home and
meet next week, and rob somebody and kill some people.

Ben Rogers said he couldn't get out much, only Sundays, and so he wanted
to begin next Sunday; but all the boys said it would be wicked to do it
on Sunday, and that settled the thing.  They agreed to get together and
fix a day as soon as they could, and then we elected Tom Sawyer first
captain and Jo Harper second captain of the Gang, and so started home.

I clumb up the shed and crept into my window just before day was
breaking. My new clothes was all greased up and clayey, and I was
dog-tired.


CHAPTER III.

WELL, I got a good going-over in the morning from old Miss Watson on
account of my clothes; but the widow she didn't scold, but only cleaned
off the grease and clay, and looked so sorry that I thought I would
behave awhile if I could.  Then Miss Watson she took me in the closet
and prayed, but nothing come of it.  She told me to pray every day, and
whatever I asked for I would get it.  But it warn't so.  I tried it.
Once I got a fish-line, but no hooks.  It warn't any good to me without
hooks.  I tried for the hooks three or four times, but somehow I
couldn't make it work.  By and by, one day, I asked Miss Watson to
try for me, but she said I was a fool.  She never told me why, and I
couldn't make it out no way.

I set down one time back in the woods, and had a long think about it.
 I says to myself, if a body can get anything they pray for, why don't
Deacon Winn get back the money he lost on pork?  Why can't the widow get
back her silver snuffbox that was stole?  Why can't Miss Watson fat up?
No, says I to my self, there ain't nothing in it.  I went and told the
widow about it, and she said the thing a body could get by praying for
it was "spiritual gifts."  This was too many for me, but she told me
what she meant--I must help other people, and do everything I could for
other people, and look out for them all the time, and never think about
myself. This was including Miss Watson, as I took it.  I went out in the
woods and turned it over in my mind a long time, but I couldn't see no
advantage about it--except for the other people; so at last I reckoned
I wouldn't worry about it any more, but just let it go.  Sometimes the
widow would take me one side and talk about Providence in a way to make
a body's mouth water; but maybe next day Miss Watson would take hold
and knock it all down again.  I judged I could see that there was two
Providences, and a poor chap would stand considerable show with the
widow's Providence, but if Miss Watson's got him there warn't no help
for him any more.  I thought it all out, and reckoned I would belong
to the widow's if he wanted me, though I couldn't make out how he was
a-going to be any better off then than what he was before, seeing I was
so ignorant, and so kind of low-down and ornery.

Pap he hadn't been seen for more than a year, and that was comfortable
for me; I didn't want to see him no more.  He used to always whale me
when he was sober and could get his hands on me; though I used to take
to the woods most of the time when he was around.  Well, about this time
he was found in the river drownded, about twelve mile above town, so
people said.  They judged it was him, anyway; said this drownded man was
just his size, and was ragged, and had uncommon long hair, which was all
like pap; but they couldn't make nothing out of the face, because it had
been in the water so long it warn't much like a face at all.  They said
he was floating on his back in the water.  They took him and buried him
on the bank.  But I warn't comfortable long, because I happened to think
of something.  I knowed mighty well that a drownded man don't float on
his back, but on his face.  So I knowed, then, that this warn't pap, but
a woman dressed up in a man's clothes.  So I was uncomfortable again.
 I judged the old man would turn up again by and by, though I wished he
wouldn't.

We played robber now and then about a month, and then I resigned.  All
the boys did.  We hadn't robbed nobody, hadn't killed any people, but
only just pretended.  We used to hop out of the woods and go charging
down on hog-drivers and women in carts taking garden stuff to market,
but we never hived any of them.  Tom Sawyer called the hogs "ingots,"
 and he called the turnips and stuff "julery," and we would go to the
cave and powwow over what we had done, and how many people we had killed
and marked.  But I couldn't see no profit in it.  One time Tom sent a
boy to run about town with a blazing stick, which he called a slogan
(which was the sign for the Gang to get together), and then he said he
had got secret news by his spies that next day a whole parcel of Spanish
merchants and rich A-rabs was going to camp in Cave Hollow with two
hundred elephants, and six hundred camels, and over a thousand "sumter"
 mules, all loaded down with di'monds, and they didn't have only a guard
of four hundred soldiers, and so we would lay in ambuscade, as he called
it, and kill the lot and scoop the things.  He said we must slick up
our swords and guns, and get ready.  He never could go after even a
turnip-cart but he must have the swords and guns all scoured up for it,
though they was only lath and broomsticks, and you might scour at them
till you rotted, and then they warn't worth a mouthful of ashes more
than what they was before.  I didn't believe we could lick such a crowd
of Spaniards and A-rabs, but I wanted to see the camels and elephants,
so I was on hand next day, Saturday, in the ambuscade; and when we got
the word we rushed out of the woods and down the hill.  But there warn't
no Spaniards and A-rabs, and there warn't no camels nor no elephants.
 It warn't anything but a Sunday-school picnic, and only a primer-class
at that.  We busted it up, and chased the children up the hollow; but we
never got anything but some doughnuts and jam, though Ben Rogers got
a rag doll, and Jo Harper got a hymn-book and a tract; and then the
teacher charged in, and made us drop everything and cut.

 I didn't see no di'monds, and I told Tom Sawyer so.  He said there was
loads of them there, anyway; and he said there was A-rabs there, too,
and elephants and things.  I said, why couldn't we see them, then?  He
said if I warn't so ignorant, but had read a book called Don Quixote, I
would know without asking.  He said it was all done by enchantment.  He
said there was hundreds of soldiers there, and elephants and treasure,
and so on, but we had enemies which he called magicians; and they had
turned the whole thing into an infant Sunday-school, just out of spite.
 I said, all right; then the thing for us to do was to go for the
magicians.  Tom Sawyer said I was a numskull.

"Why," said he, "a magician could call up a lot of genies, and they
would hash you up like nothing before you could say Jack Robinson.  They
are as tall as a tree and as big around as a church."

"Well," I says, "s'pose we got some genies to help _us_--can't we lick
the other crowd then?"

"How you going to get them?"

"I don't know.  How do _they_ get them?"

"Why, they rub an old tin lamp or an iron ring, and then the genies
come tearing in, with the thunder and lightning a-ripping around and the
smoke a-rolling, and everything they're told to do they up and do it.
 They don't think nothing of pulling a shot-tower up by the roots, and
belting a Sunday-school superintendent over the head with it--or any
other man."

"Who makes them tear around so?"

"Why, whoever rubs the lamp or the ring.  They belong to whoever rubs
the lamp or the ring, and they've got to do whatever he says.  If he
tells them to build a palace forty miles long out of di'monds, and fill
it full of chewing-gum, or whatever you want, and fetch an emperor's
daughter from China for you to marry, they've got to do it--and they've
got to do it before sun-up next morning, too.  And more:  they've got
to waltz that palace around over the country wherever you want it, you
understand."

"Well," says I, "I think they are a pack of flat-heads for not keeping
the palace themselves 'stead of fooling them away like that.  And what's
more--if I was one of them I would see a man in Jericho before I would
drop my business and come to him for the rubbing of an old tin lamp."

"How you talk, Huck Finn.  Why, you'd _have_ to come when he rubbed it,
whether you wanted to or not."

"What! and I as high as a tree and as big as a church?  All right, then;
I _would_ come; but I lay I'd make that man climb the highest tree there
was in the country."

"Shucks, it ain't no use to talk to you, Huck Finn.  You don't seem to
know anything, somehow--perfect saphead."

I thought all this over for two or three days, and then I reckoned I
would see if there was anything in it.  I got an old tin lamp and an
iron ring, and went out in the woods and rubbed and rubbed till I sweat
like an Injun, calculating to build a palace and sell it; but it warn't
no use, none of the genies come.  So then I judged that all that stuff
was only just one of Tom Sawyer's lies.  I reckoned he believed in the
A-rabs and the elephants, but as for me I think different.  It had all
the marks of a Sunday-school.
"""


# Excerpt from "The Call of the Wild", by Jack London.
# Text from project Gutenberg, public domain.
text3_call_of_the_wild = b"""
Chapter I. Into the Primitive

"Old longings nomadic leap,
Chafing at custom's chain;
Again from its brumal sleep
Wakens the ferine strain."


Buck did not read the newspapers, or he would have known that trouble
was brewing, not alone for himself, but for every tide-water dog,
strong of muscle and with warm, long hair, from Puget Sound to San
Diego. Because men, groping in the Arctic darkness, had found a yellow
metal, and because steamship and transportation companies were booming
the find, thousands of men were rushing into the Northland. These men
wanted dogs, and the dogs they wanted were heavy dogs, with strong
muscles by which to toil, and furry coats to protect them from the
frost.

Buck lived at a big house in the sun-kissed Santa Clara Valley. Judge
Miller's place, it was called. It stood back from the road, half hidden
among the trees, through which glimpses could be caught of the wide
cool veranda that ran around its four sides. The house was approached
by gravelled driveways which wound about through wide-spreading lawns
and under the interlacing boughs of tall poplars. At the rear things
were on even a more spacious scale than at the front. There were great
stables, where a dozen grooms and boys held forth, rows of vine-clad
servants' cottages, an endless and orderly array of outhouses, long
grape arbors, green pastures, orchards, and berry patches. Then there
was the pumping plant for the artesian well, and the big cement tank
where Judge Miller's boys took their morning plunge and kept cool in
the hot afternoon.

And over this great demesne Buck ruled. Here he was born, and here he
had lived the four years of his life. It was true, there were other
dogs, There could not but be other dogs on so vast a place, but they
did not count. They came and went, resided in the populous kennels, or
lived obscurely in the recesses of the house after the fashion of
Toots, the Japanese pug, or Ysabel, the Mexican hairless, -- strange
creatures that rarely put nose out of doors or set foot to ground. On
the other hand, there were the fox terriers, a score of them at least,
who yelped fearful promises at Toots and Ysabel looking out of the
windows at them and protected by a legion of housemaids armed with
brooms and mops.

But Buck was neither house-dog nor kennel-dog. The whole realm was his.
He plunged into the swimming tank or went hunting with the Judge's
sons; he escorted Mollie and Alice, the Judge's daughters, on long
twilight or early morning rambles; on wintry nights he lay at the
Judge's feet before the roaring library fire; he carried the Judge's
grandsons on his back, or rolled them in the grass, and guarded their
footsteps through wild adventures down to the fountain in the stable
yard, and even beyond, where the paddocks were, and the berry patches.
Among the terriers he stalked imperiously, and Toots and Ysabel he
utterly ignored, for he was king, -- king over all creeping, crawling,
flying things of Judge Miller's place, humans included.

His father, Elmo, a huge St. Bernard, had been the Judge's inseparable
companion, and Buck bid fair to follow in the way of his father. He was
not so large, -- he weighed only one hundred and forty pounds, -- for his
mother, Shep, had been a Scotch shepherd dog. Nevertheless, one hundred
and forty pounds, to which was added the dignity that comes of good
living and universal respect, enabled him to carry himself in right
royal fashion. During the four years since his puppyhood he had lived
the life of a sated aristocrat; he had a fine pride in himself, was
even a trifle egotistical, as country gentlemen sometimes become
because of their insular situation. But he had saved himself by not
becoming a mere pampered house-dog. Hunting and kindred outdoor
delights had kept down the fat and hardened his muscles; and to him, as
to the cold-tubbing races, the love of water had been a tonic and a
health preserver.

And this was the manner of dog Buck was in the fall of 1897, when the
Klondike strike dragged men from all the world into the frozen North.
But Buck did not read the newspapers, and he did not know that Manuel,
one of the gardener's helpers, was an undesirable acquaintance. Manuel
had one besetting sin. He loved to play Chinese lottery. Also, in his
gambling, he had one besetting weakness -- faith in a system; and this
made his damnation certain. For to play a system requires money, while
the wages of a gardener's helper do not lap over the needs of a wife
and numerous progeny.

The Judge was at a meeting of the Raisin Growers' Association, and the
boys were busy organizing an athletic club, on the memorable night of
Manuel's treachery. No one saw him and Buck go off through the orchard
on what Buck imagined was merely a stroll. And with the exception of a
solitary man, no one saw them arrive at the little flag station known
as College Park. This man talked with Manuel, and money chinked between
them.

"You might wrap up the goods before you deliver 'm," the stranger said
gruffly, and Manuel doubled a piece of stout rope around Buck's neck
under the collar.

"Twist it, an' you'll choke 'm plentee," said Manuel, and the stranger
grunted a ready affirmative.

Buck had accepted the rope with quiet dignity. To be sure, it was an
unwonted performance: but he had learned to trust in men he knew, and
to give them credit for a wisdom that outreached his own. But when the
ends of the rope were placed in the stranger's hands, he growled
menacingly. He had merely intimated his displeasure, in his pride
believing that to intimate was to command. But to his surprise the rope
tightened around his neck, shutting off his breath. In quick rage he
sprang at the man, who met him halfway, grappled him close by the
throat, and with a deft twist threw him over on his back. Then the rope
tightened mercilessly, while Buck struggled in a fury, his tongue
lolling out of his mouth and his great chest panting futilely. Never in
all his life had he been so vilely treated, and never in all his life
had he been so angry. But his strength ebbed, his eyes glazed, and he
knew nothing when the train was flagged and the two men threw him into
the baggage car.

The next he knew, he was dimly aware that his tongue was hurting and
that he was being jolted along in some kind of a conveyance. The hoarse
shriek of a locomotive whistling a crossing told him where he was. He
had travelled too often with the Judge not to know the sensation of
riding in a baggage car. He opened his eyes, and into them came the
unbridled anger of a kidnapped king. The man sprang for his throat, but
Buck was too quick for him. His jaws closed on the hand, nor did they
relax till his senses were choked out of him once more.

"Yep, has fits," the man said, hiding his mangled hand from the
baggageman, who had been attracted by the sounds of struggle. "I'm
takin' 'm up for the boss to 'Frisco. A crack dog-doctor there thinks
that he can cure 'm."

Concerning that night's ride, the man spoke most eloquently for
himself, in a little shed back of a saloon on the San Francisco water
front.

"All I get is fifty for it," he grumbled; "an' I wouldn't do it over
for a thousand, cold cash."

His hand was wrapped in a bloody handkerchief, and the right trouser
leg was ripped from knee to ankle.

"How much did the other mug get?" the saloon-keeper demanded.

"A hundred," was the reply. "Wouldn't take a sou less, so help me."

"That makes a hundred and fifty," the saloon-keeper calculated; "and
he's worth it, or I'm a squarehead."

The kidnapper undid the bloody wrappings and looked at his lacerated
hand. "If I don't get the hydrophoby -- "

"It'll be because you was born to hang," laughed the saloon-keeper.
"Here, lend me a hand before you pull your freight," he added.

Dazed, suffering intolerable pain from throat and tongue, with the life
half throttled out of him, Buck attempted to face his tormentors. But
he was thrown down and choked repeatedly, till they succeeded in filing
the heavy brass collar from off his neck. Then the rope was removed,
and he was flung into a cagelike crate.

There he lay for the remainder of the weary night, nursing his wrath
and wounded pride. He could not understand what it all meant. What did
they want with him, these strange men? Why were they keeping him pent
up in this narrow crate? He did not know why, but he felt oppressed by
the vague sense of impending calamity. Several times during the night
he sprang to his feet when the shed door rattled open, expecting to see
the Judge, or the boys at least. But each time it was the bulging face
of the saloon-keeper that peered in at him by the sickly light of a
tallow candle. And each time the joyful bark that trembled in Buck's
throat was twisted into a savage growl.

But the saloon-keeper let him alone, and in the morning four men
entered and picked up the crate. More tormentors, Buck decided, for
they were evil-looking creatures, ragged and unkempt; and he stormed
and raged at them through the bars. They only laughed and poked sticks
at him, which he promptly assailed with his teeth till he realized that
that was what they wanted. Whereupon he lay down sullenly and allowed
the crate to be lifted into a wagon. Then he, and the crate in which he
was imprisoned, began a passage through many hands. Clerks in the
express office took charge of him; he was carted about in another
wagon; a truck carried him, with an assortment of boxes and parcels,
upon a ferry steamer; he was trucked off the steamer into a great
railway depot, and finally he was deposited in an express car.

For two days and nights this express car was dragged along at the tail
of shrieking locomotives; and for two days and nights Buck neither ate
nor drank. In his anger he had met the first advances of the express
messengers with growls, and they had retaliated by teasing him. When he
flung himself against the bars, quivering and frothing, they laughed at
him and taunted him. They growled and barked like detestable dogs,
mewed, and flapped their arms and crowed. It was all very silly, he
knew; but therefore the more outrage to his dignity, and his anger
waxed and waxed. He did not mind the hunger so much, but the lack of
water caused him severe suffering and fanned his wrath to fever-pitch.
For that matter, high-strung and finely sensitive, the ill treatment
had flung him into a fever, which was fed by the inflammation of his
parched and swollen throat and tongue.

He was glad for one thing: the rope was off his neck. That had given
them an unfair advantage; but now that it was off, he would show them.
They would never get another rope around his neck. Upon that he was
resolved. For two days and nights he neither ate nor drank, and during
those two days and nights of torment, he accumulated a fund of wrath
that boded ill for whoever first fell foul of him. His eyes turned
blood-shot, and he was metamorphosed into a raging fiend. So changed
was he that the Judge himself would not have recognized him; and the
express messengers breathed with relief when they bundled him off the
train at Seattle.

Four men gingerly carried the crate from the wagon into a small,
high-walled back yard. A stout man, with a red sweater that sagged
generously at the neck, came out and signed the book for the driver.
That was the man, Buck divined, the next tormentor, and he hurled
himself savagely against the bars. The man smiled grimly, and brought a
hatchet and a club.

"You ain't going to take him out now?" the driver asked.

"Sure," the man replied, driving the hatchet into the crate for a pry.

There was an instantaneous scattering of the four men who had carried
it in, and from safe perches on top the wall they prepared to watch the
performance.

Buck rushed at the splintering wood, sinking his teeth into it, surging
and wrestling with it. Wherever the hatchet fell on the outside, he was
there on the inside, snarling and growling, as furiously anxious to get
out as the man in the red sweater was calmly intent on getting him out.

"Now, you red-eyed devil," he said, when he had made an opening
sufficient for the passage of Buck's body. At the same time he dropped
the hatchet and shifted the club to his right hand.

And Buck was truly a red-eyed devil, as he drew himself together for
the spring, hair bristling, mouth foaming, a mad glitter in his
blood-shot eyes. Straight at the man he launched his one hundred and
forty pounds of fury, surcharged with the pent passion of two days and
nights. In mid air, just as his jaws were about to close on the man, he
received a shock that checked his body and brought his teeth together
with an agonizing clip. He whirled over, fetching the ground on his
back and side. He had never been struck by a club in his life, and did
not understand. With a snarl that was part bark and more scream he was
again on his feet and launched into the air. And again the shock came
and he was brought crushingly to the ground. This time he was aware
that it was the club, but his madness knew no caution. A dozen times he
charged, and as often the club broke the charge and smashed him down.

After a particularly fierce blow, he crawled to his feet, too dazed to
rush. He staggered limply about, the blood flowing from nose and mouth
and ears, his beautiful coat sprayed and flecked with bloody <redacted>er.
Then the man advanced and deliberately dealt him a frightful blow on
the nose. All the pain he had endured was as nothing compared with the
exquisite agony of this. With a roar that was almost lionlike in its
ferocity, he again hurled himself at the man. But the man, shifting the
club from right to left, coolly caught him by the under jaw, at the
same time wrenching downward and backward. Buck described a complete
circle in the air, and half of another, then crashed to the ground on
his head and chest.

For the last time he rushed. The man struck the shrewd blow he had
purposely withheld for so long, and Buck crumpled up and went down,
knocked utterly senseless.

"He's no slouch at dog-breakin', that's wot I say," one of the men on
the wall cried enthusiastically.

"Druther break cayuses any day, and twice on Sundays," was the reply of
the driver, as he climbed on the wagon and started the horses.

Buck's senses came back to him, but not his strength. He lay where he
had fallen, and from there he watched the man in the red sweater.

"'Answers to the name of Buck,'" the man soliloquized, quoting from the
saloon-keeper's letter which had announced the consignment of the crate
and contents. "Well, Buck, my boy," he went on in a genial voice,
"we've had our little ruction, and the best thing we can do is to let
it go at that. You've learned your place, and I know mine. Be a good
dog and all 'll go well and the goose hang high. Be a bad dog, and I'll
whale the stuffin' outa you. Understand?"

As he spoke he fearlessly patted the head he had so mercilessly
pounded, and though Buck's hair involuntarily bristled at touch of the
hand, he endured it without protest. When the man brought him water he
drank eagerly, and later bolted a generous meal of raw meat, chunk by
chunk, from the man's hand.

He was beaten (he knew that); but he was not broken. He saw, once for
all, that he stood no chance against a man with a club. He had learned
the lesson, and in all his after life he never forgot it. That club was
a revelation. It was his introduction to the reign of primitive law,
and he met the introduction halfway. The facts of life took on a
fiercer aspect; and while he faced that aspect uncowed, he faced it
with all the latent cunning of his nature aroused. As the days went by,
other dogs came, in crates and at the ends of ropes, some docilely, and
some raging and roaring as he had come; and, one and all, he watched
them pass under the dominion of the man in the red sweater. Again and
again, as he looked at each brutal performance, the lesson was driven
home to Buck: a man with a club was a lawgiver, a master to be obeyed,
though not necessarily conciliated. Of this last Buck was never guilty,
though he did see beaten dogs that fawned upon the man, and wagged
their tails, and licked his hand. Also he saw one dog, that would
neither conciliate nor obey, finally killed in the struggle for
mastery.

Now and again men came, strangers, who talked excitedly, wheedlingly,
and in all kinds of fashions to the man in the red sweater. And at such
times that money passed between them the strangers took one or more of
the dogs away with them. Buck wondered where they went, for they never
came back; but the fear of the future was strong upon him, and he was
glad each time when he was not selected.

Yet his time came, in the end, in the form of a little weazened man who
spat broken English and many strange and uncouth exclamations which
Buck could not understand.

"Sacredam!" he cried, when his eyes lit upon Buck. "Dat one dam bully
dog! Eh? How moch?"

"Three hundred, and a present at that," was the prompt reply of the man
in the red sweater. "And seem' it's government money, you ain't got no
kick coming, eh, Perrault?"

Perrault grinned. Considering that the price of dogs had been boomed
skyward by the unwonted demand, it was not an unfair sum for so fine an
animal. The Canadian Government would be no loser, nor would its
despatches travel the slower. Perrault knew dogs, and when he looked at
Buck he knew that he was one in a thousand -- "One in ten t'ousand," he
commented mentally.

Buck saw money pass between them, and was not surprised when Curly, a
good-natured Newfoundland, and he were led away by the little weazened
man. That was the last he saw of the man in the red sweater, and as
Curly and he looked at receding Seattle from the deck of the _Narwhal_,
it was the last he saw of the warm Southland. Curly and he were taken
below by Perrault and turned over to a black-faced giant called
Francois. Perrault was a French-Canadian, and swarthy; but Francois was
a French-Canadian half-breed, and twice as swarthy. They were a new
kind of men to Buck (of which he was destined to see many more), and
while he developed no affection for them, he none the less grew
honestly to respect them. He speedily learned that Perrault and
Francois were fair men, calm and impartial in administering justice,
and too wise in the way of dogs to be fooled by dogs.

In the 'tween-decks of the _Narwhal_, Buck and Curly joined two other
dogs. One of them was a big, snow-white fellow from Spitzbergen who had
been brought away by a whaling captain, and who had later accompanied a
Geological Survey into the Barrens. He was friendly, in a treacherous
sort of way, smiling into one's face the while he meditated some
underhand trick, as, for instance, when he stole from Buck's food at
the first meal. As Buck sprang to punish him, the lash of Francois's
whip sang through the air, reaching the culprit first; and nothing
remained to Buck but to recover the bone. That was fair of Francois, he
decided, and the half-breed began his rise in Buck's estimation.

The other dog made no advances, nor received any; also, he did not
attempt to steal from the newcomers. He was a gloomy, morose fellow,
and he showed Curly plainly that all he desired was to be left alone,
and further, that there would be trouble if he were not left alone.
"Dave" he was called, and he ate and slept, or yawned between times,
and took interest in nothing, not even when the _Narwhal_ crossed Queen
Charlotte Sound and rolled and pitched and bucked like a thing
possessed. When Buck and Curly grew excited, half wild with fear, he
raised his head as though annoyed, favored them with an incurious
glance, yawned, and went to sleep again.

Day and night the ship throbbed to the tireless pulse of the propeller,
and though one day was very like another, it was apparent to Buck that
the weather was steadily growing colder. At last, one morning, the
propeller was quiet, and the _Narwhal_ was pervaded with an atmosphere
of excitement. He felt it, as did the other dogs, and knew that a
change was at hand. Francois leashed them and brought them on deck. At
the first step upon the cold surface, Buck's feet sank into a white
mushy something very like mud. He sprang back with a snort. More of
this white stuff was falling through the air. He shook himself, but
more of it fell upon him. He sniffed it curiously, then licked some up
on his tongue. It bit like fire, and the next instant was gone. This
puzzled him. He tried it again, with the same result. The onlookers
laughed uproariously, and he felt ashamed, he knew not why, for it was
his first snow.


Chapter II. The Law of Club and Fang

Buck's first day on the Dyea beach was like a nightmare. Every hour was
filled with shock and surprise. He had been suddenly jerked from the
heart of civilization and flung into the heart of things primordial. No
lazy, sun-kissed life was this, with nothing to do but loaf and be
bored. Here was neither peace, nor rest, nor a moment's safety. All was
confusion and action, and every moment life and limb were in peril.
There was imperative need to be constantly alert; for these dogs and
men were not town dogs and men. They were savages, all of them, who
knew no law but the law of club and fang.

He had never seen dogs fight as these wolfish creatures fought, and his
first experience taught him an unforgetable lesson. It is true, it was
a vicarious experience, else he would not have lived to profit by it.
Curly was the victim. They were camped near the log store, where she,
in her friendly way, made advances to a husky dog the size of a
full-grown wolf, though not half so large as she. There was no warning,
only a leap in like a flash, a metallic clip of teeth, a leap out
equally swift, and Curly's face was ripped open from eye to jaw.

It was the wolf manner of fighting, to strike and leap away; but there
was more to it than this. Thirty or forty huskies ran to the spot and
surrounded the combatants in an intent and silent circle. Buck did not
comprehend that silent intentness, nor the eager way with which they
were licking their chops. Curly rushed her antagonist, who struck again
and leaped aside. He met her next rush with his chest, in a peculiar
fashion that tumbled her off her feet. She never regained them, This
was what the onlooking huskies had waited for. They closed in upon her,
snarling and yelping, and she was buried, screaming with agony, beneath
the bristling mass of bodies.

So sudden was it, and so unexpected, that Buck was taken aback. He saw
Spitz run out his scarlet tongue in a way he had of laughing; and he
saw Francois, swinging an axe, spring into the mess of dogs. Three men
with clubs were helping him to scatter them. It did not take long. Two
minutes from the time Curly went down, the last of her assailants were
clubbed off. But she lay there limp and lifeless in the bloody,
trampled snow, almost literally torn to pieces, the swart half-breed
standing over her and cursing horribly. The scene often came back to
Buck to trouble him in his sleep. So that was the way. No fair play.
Once down, that was the end of you. Well, he would see to it that he
never went down. Spitz ran out his tongue and laughed again, and from
that moment Buck hated him with a bitter and deathless hatred.

Before he had recovered from the shock caused by the tragic passing of
Curly, he received another shock. Francois fastened upon him an
arrangement of straps and buckles. It was a harness, such as he had
seen the grooms put on the horses at home. And as he had seen horses
work, so he was set to work, hauling Francois on a sled to the forest
that fringed the valley, and returning with a load of firewood. Though
his dignity was sorely hurt by thus being made a draught animal, he was
too wise to rebel. He buckled down with a will and did his best, though
it was all new and strange. Francois was stern, demanding instant
obedience, and by virtue of his whip receiving instant obedience; while
Dave, who was an experienced wheeler, nipped Buck's hind quarters
whenever he was in error. Spitz was the leader, likewise experienced,
and while he could not always get at Buck, he growled sharp reproof now
and again, or cunningly threw his weight in the traces to jerk Buck
into the way he should go. Buck learned easily, and under the combined
tuition of his two mates and Francois made remarkable progress. Ere
they returned to camp he knew enough to stop at "ho," to go ahead at
"mush," to swing wide on the bends, and to keep clear of the wheeler
when the loaded sled shot downhill at their heels.

"T'ree vair' good dogs," Francois told Perrault. "Dat Buck, heem pool
lak hell. I tich heem queek as anyt'ing."

By afternoon, Perrault, who was in a hurry to be on the trail with his
despatches, returned with two more dogs. "Billee" and "Joe" he called
them, two brothers, and true huskies both. Sons of the one mother
though they were, they were as different as day and night. Billee's one
fault was his excessive good nature, while Joe was the very opposite,
sour and introspective, with a perpetual snarl and a malignant eye.
Buck received them in comradely fashion, Dave ignored them, while Spitz
proceeded to thrash first one and then the other. Billee wagged his
tail appeasingly, turned to run when he saw that appeasement was of no
avail, and cried (still appeasingly) when Spitz's sharp teeth scored
his flank. But no matter how Spitz circled, Joe whirled around on his
heels to face him, mane bristling, ears laid back, lips writhing and
snarling, jaws clipping together as fast as he could snap, and eyes
diabolically gleaming -- the incarnation of belligerent fear. So terrible
was his appearance that Spitz was forced to forego disciplining him;
but to cover his own discomfiture he turned upon the inoffensive and
wailing Billee and drove him to the confines of the camp.

By evening Perrault secured another dog, an old husky, long and lean
and gaunt, with a battle-scarred face and a single eye which flashed a
warning of prowess that commanded respect. He was called Sol-leks,
which means the Angry One. Like Dave, he asked nothing, gave nothing,
expected nothing; and when he marched slowly and deliberately into
their midst, even Spitz left him alone. He had one peculiarity which
Buck was unlucky enough to discover. He did not like to be approached
on his blind side. Of this offence Buck was unwittingly guilty, and the
first knowledge he had of his indiscretion was when Sol-leks whirled
upon him and slashed his shoulder to the bone for three inches up and
down. Forever after Buck avoided his blind side, and to the last of
their comradeship had no more trouble. His only apparent ambition, like
Dave's, was to be left alone; though, as Buck was afterward to learn,
each of them possessed one other and even more vital ambition.

That night Buck faced the great problem of sleeping. The tent,
illumined by a candle, glowed warmly in the midst of the white plain;
and when he, as a matter of course, entered it, both Perrault and
Francois bombarded him with curses and cooking utensils, till he
recovered from his consternation and fled ignominiously into the outer
cold. A chill wind was blowing that nipped him sharply and bit with
especial venom into his wounded shoulder. He lay down on the snow and
attempted to sleep, but the frost soon drove him shivering to his feet.
Miserable and disconsolate, he wandered about among the many tents,
only to find that one place was as cold as another. Here and there
savage dogs rushed upon him, but he bristled his neck-hair and snarled
(for he was learning fast), and they let him go his way unmolested.

Finally an idea came to him. He would return and see how his own
team-mates were making out. To his astonishment, they had disappeared.
Again he wandered about through the great camp, looking for them, and
again he returned. Were they in the tent? No, that could not be, else
he would not have been driven out. Then where could they possibly be?
With drooping tail and shivering body, very forlorn indeed, he
aimlessly circled the tent. Suddenly the snow gave way beneath his fore
legs and he sank down. Something wriggled under his feet. He sprang
back, bristling and snarling, fearful of the unseen and unknown. But a
friendly little yelp reassured him, and he went back to investigate. A
whiff of warm air ascended to his nostrils, and there, curled up under
the snow in a snug ball, lay Billee. He whined placatingly, squirmed
and wriggled to show his good will and intentions, and even ventured,
as a bribe for peace, to lick Buck's face with his warm wet tongue.

Another lesson. So that was the way they did it, eh? Buck confidently
selected a spot, and with much fuss and waste effort proceeded to dig a
hole for himself. In a trice the heat from his body filled the confined
space and he was asleep. The day had been long and arduous, and he
slept soundly and comfortably, though he growled and barked and
wrestled with bad dreams.

Nor did he open his eyes till roused by the noises of the waking camp.
At first he did not know where he was. It had snowed during the night
and he was completely buried. The snow walls pressed him on every side,
and a great surge of fear swept through him -- the fear of the wild thing
for the trap. It was a token that he was harking back through his own
life to the lives of his forebears; for he was a civilized dog, an
unduly civilized dog, and of his own experience knew no trap and so
could not of himself fear it. The muscles of his whole body contracted
spasmodically and instinctively, the hair on his neck and shoulders
stood on end, and with a ferocious snarl he bounded straight up into
the blinding day, the snow flying about him in a flashing cloud. Ere he
landed on his feet, he saw the white camp spread out before him and
knew where he was and remembered all that had passed from the time he
went for a stroll with Manuel to the hole he had dug for himself the
night before.

A shout from Francois hailed his appearance. "Wot I say?" the
dog-driver cried to Perrault. "Dat Buck for sure learn queek as
anyt'ing."

Perrault nodded gravely. As courier for the Canadian Government,
bearing important despatches, he was anxious to secure the best dogs,
and he was particularly gladdened by the possession of Buck.

Three more huskies were added to the team inside an hour, making a
total of nine, and before another quarter of an hour had passed they
were in harness and swinging up the trail toward the Dyea Canyon. Buck
was glad to be gone, and though the work was hard he found he did not
particularly despise it. He was surprised at the eagerness which
animated the whole team and which was communicated to him; but still
more surprising was the change wrought in Dave and Sol-leks. They were
new dogs, utterly transformed by the harness. All passiveness and
unconcern had dropped from them. They were alert and active, anxious
that the work should go well, and fiercely irritable with whatever, by
delay or confusion, retarded that work. The toil of the traces seemed
the supreme expression of their being, and all that they lived for and
the only thing in which they took delight.

Dave was wheeler or sled dog, pulling in front of him was Buck, then
came Sol-leks; the rest of the team was strung out ahead, single file,
to the leader, which position was filled by Spitz.

Buck had been purposely placed between Dave and Sol-leks so that he
might receive instruction. Apt scholar that he was, they were equally
apt teachers, never allowing him to linger long in error, and enforcing
their teaching with their sharp teeth. Dave was fair and very wise. He
never nipped Buck without cause, and he never failed to nip him when he
stood in need of it. As Francois's whip backed him up, Buck found it to
be cheaper to mend his ways than to retaliate. Once, during a brief
halt, when he got tangled in the traces and delayed the start, both
Dave and Sol-leks flew at him and administered a sound trouncing. The
resulting tangle was even worse, but Buck took good care to keep the
traces clear thereafter; and ere the day was done, so well had he
mastered his work, his mates about ceased nagging him. Francois's whip
snapped less frequently, and Perrault even honored Buck by lifting up
his feet and carefully examining them.

It was a hard day's run, up the Canyon, through Sheep Camp, past the
Scales and the timber line, across glaciers and snowdrifts hundreds of
feet deep, and over the great Chilcoot Divide, which stands between the
salt water and the fresh and guards forbiddingly the sad and lonely
North. They made good time down the chain of lakes which fills the
craters of extinct volcanoes, and late that night pulled into the huge
camp at the head of Lake Bennett, where thousands of goldseekers were
building boats against the break-up of the ice in the spring. Buck made
his hole in the snow and slept the sleep of the exhausted just, but all
too early was routed out in the cold darkness and harnessed with his
mates to the sled.

That day they made forty miles, the trail being packed; but the next
day, and for many days to follow, they broke their own trail, worked
harder, and made poorer time. As a rule, Perrault travelled ahead of
the team, packing the snow with webbed shoes to make it easier for
them. Francois, guiding the sled at the gee-pole, sometimes exchanged
places with him, but not often. Perrault was in a hurry, and he prided
himself on his knowledge of ice, which knowledge was indispensable, for
the fall ice was very thin, and where there was swift water, there was
no ice at all.

Day after day, for days unending, Buck toiled in the traces. Always,
they broke camp in the dark, and the first gray of dawn found them
hitting the trail with fresh miles reeled off behind them. And always
they pitched camp after dark, eating their bit of fish, and crawling to
sleep into the snow. Buck was ravenous. The pound and a half of
sun-dried salmon, which was his ration for each day, seemed to go
nowhere. He never had enough, and suffered from perpetual hunger pangs.
Yet the other dogs, because they weighed less and were born to the
life, received a pound only of the fish and managed to keep in good
condition.

He swiftly lost the fastidiousness which had characterized his old
life. A dainty eater, he found that his mates, finishing first, robbed
him of his unfinished ration. There was no defending it. While he was
fighting off two or three, it was disappearing down the throats of the
others. To remedy this, he ate as fast as they; and, so greatly did
hunger compel him, he was not above taking what did not belong to him.
He watched and learned. When he saw Pike, one of the new dogs, a clever
malingerer and thief, slyly steal a slice of bacon when Perrault's back
was turned, he duplicated the performance the following day, getting
away with the whole chunk. A great uproar was raised, but he was
unsuspected; while Dub, an awkward blunderer who was always getting
caught, was punished for Buck's misdeed.

This first theft marked Buck as fit to survive in the hostile Northland
environment. It marked his adaptability, his capacity to adjust himself
to changing conditions, the lack of which would have meant swift and
terrible death. It marked, further, the decay or going to pieces of his
moral nature, a vain thing and a handicap in the ruthless struggle for
existence. It was all well enough in the Southland, under the law of
love and fellowship, to respect private property and personal feelings;
but in the Northland, under the law of club and fang, whoso took such
things into account was a fool, and in so far as he observed them he
would fail to prosper.

Not that Buck reasoned it out. He was fit, that was all, and
unconsciously he accommodated himself to the new mode of life. All his
days, no matter what the odds, he had never run from a fight. But the
club of the man in the red sweater had beaten into him a more
fundamental and primitive code. Civilized, he could have died for a
moral consideration, say the defence of Judge Miller's riding-whip; but
the completeness of his decivilization was now evidenced by his ability
to flee from the defence of a moral consideration and so save his hide.
He did not steal for joy of it, but because of the clamor of his
stomach. He did not rob openly, but stole secretly and cunningly, out
of respect for club and fang. In short, the things he did were done
because it was easier to do them than not to do them.

His development (or retrogression) was rapid. His muscles became hard
as iron, and he grew callous to all ordinary pain. He achieved an
internal as well as external economy. He could eat anything, no matter
how loathsome or indigestible; and, once eaten, the juices of his
stomach extracted the last least particle of nutriment; and his blood
carried it to the farthest reaches of his body, building it into the
toughest and stoutest of tissues. Sight and scent became remarkably
keen, while his hearing developed such acuteness that in his sleep he
heard the faintest sound and knew whether it heralded peace or peril.
He learned to bite the ice out with his teeth when it collected between
his toes; and when he was thirsty and there was a thick scum of ice
over the water hole, he would break it by rearing and striking it with
stiff fore legs. His most conspicuous trait was an ability to scent the
wind and forecast it a night in advance. No matter how breathless the
air when he dug his nest by tree or bank, the wind that later blew
inevitably found him to leeward, sheltered and snug.

And not only did he learn by experience, but instincts long dead became
alive again. The domesticated generations fell from him. In vague ways
he remembered back to the youth of the breed, to the time the wild dogs
ranged in packs through the primeval forest and killed their meat as
they ran it down. It was no task for him to learn to fight with cut and
slash and the quick wolf snap. In this manner had fought forgotten
ancestors. They quickened the old life within him, and the old tricks
which they had stamped into the heredity of the breed were his tricks.
They came to him without effort or discovery, as though they had been
his always. And when, on the still cold nights, he pointed his nose at
a star and howled long and wolflike, it was his ancestors, dead and
dust, pointing nose at star and howling down through the centuries and
through him. And his cadences were their cadences, the cadences which
voiced their woe and what to them was the meaning of the stiffness, and
the cold, and dark.

Thus, as token of what a puppet thing life is, the ancient song surged
through him and he came into his own again; and he came because men had
found a yellow metal in the North, and because Manuel was a gardener's
helper whose wages did not lap over the needs of his wife and divers
small copies of himself.
"""


# Excerpt from "The Prince", by Machiavelli.
# Text from project Gutenberg, public domain.
text4_the_prince = b"""
CHAPTER I -- HOW MANY KINDS OF PRINCIPALITIES THERE ARE, AND BY WHAT
MEANS THEY ARE ACQUIRED

All states, all powers, that have held and hold rule over men have been
and are either republics or principalities.

Principalities are either hereditary, in which the family has been long
established; or they are new.

The new are either entirely new, as was Milan to Francesco Sforza, or
they are, as it were, members annexed to the hereditary state of the
prince who has acquired them, as was the kingdom of Naples to that of
the King of Spain.

Such dominions thus acquired are either accustomed to live under a
prince, or to live in freedom; and are acquired either by the arms of
the prince himself, or of others, or else by fortune or by ability.


CHAPTER II -- CONCERNING HEREDITARY PRINCIPALITIES

I will leave out all discussion on republics, inasmuch as in another
place I have written of them at length, and will address myself only to
principalities. In doing so I will keep to the order indicated above,
and discuss how such principalities are to be ruled and preserved.

I say at once there are fewer difficulties in holding hereditary states,
and those long accustomed to the family of their prince, than new
ones; for it is sufficient only not to transgress the customs of his
ancestors, and to deal prudently with circumstances as they arise, for a
prince of average powers to maintain himself in his state, unless he
be deprived of it by some extraordinary and excessive force; and if he
should be so deprived of it, whenever anything sinister happens to the
usurper, he will regain it.

We have in Italy, for example, the Duke of Ferrara, who could not have
withstood the attacks of the Venetians in '84, nor those of Pope Julius
in '10, unless he had been long established in his dominions. For the
hereditary prince has less cause and less necessity to offend; hence it
happens that he will be more loved; and unless extraordinary vices cause
him to be hated, it is reasonable to expect that his subjects will be
naturally well disposed towards him; and in the antiquity and duration
of his rule the memories and motives that make for change are lost, for
one change always leaves the toothing for another.


CHAPTER III -- CONCERNING MIXED PRINCIPALITIES

But the difficulties occur in a new principality. And firstly, if it be
not entirely new, but is, as it were, a member of a state which, taken
collectively, may be called composite, the changes arise chiefly from
an inherent difficulty which there is in all new principalities; for
men change their rulers willingly, hoping to better themselves, and this
hope induces them to take up arms against him who rules: wherein they
are deceived, because they afterwards find by experience they have
gone from bad to worse. This follows also on another natural and common
necessity, which always causes a new prince to burden those who have
submitted to him with his soldiery and with infinite other hardships
which he must put upon his new acquisition.

In this way you have enemies in all those whom you have injured in
seizing that principality, and you are not able to keep those friends
who put you there because of your not being able to satisfy them in the
way they expected, and you cannot take strong measures against them,
feeling bound to them. For, although one may be very strong in armed
forces, yet in entering a province one has always need of the goodwill
of the natives.

For these reasons Louis the Twelfth, King of France, quickly occupied
Milan, and as quickly lost it; and to turn him out the first time it
only needed Lodovico's own forces; because those who had opened the
gates to him, finding themselves deceived in their hopes of future
benefit, would not endure the ill-treatment of the new prince. It is
very true that, after acquiring rebellious provinces a second time,
they are not so lightly lost afterwards, because the prince, with
little reluctance, takes the opportunity of the rebellion to punish the
delinquents, to clear out the suspects, and to strengthen himself in the
weakest places. Thus to cause France to lose Milan the first time it was
enough for the Duke Lodovico(*) to raise insurrections on the borders;
but to cause him to lose it a second time it was necessary to bring
the whole world against him, and that his armies should be defeated and
driven out of Italy; which followed from the causes above mentioned.

     (*) Duke Lodovico was Lodovico Moro, a son of Francesco
     Sforza, who married Beatrice d'Este. He ruled over Milan
     from 1494 to 1500, and died in 1510.

Nevertheless Milan was taken from France both the first and the second
time. The general reasons for the first have been discussed; it remains
to name those for the second, and to see what resources he had, and what
any one in his situation would have had for maintaining himself more
securely in his acquisition than did the King of France.

Now I say that those dominions which, when acquired, are added to an
ancient state by him who acquires them, are either of the same country
and language, or they are not. When they are, it is easier to hold them,
especially when they have not been accustomed to self-government; and
to hold them securely it is enough to have destroyed the family of the
prince who was ruling them; because the two peoples, preserving in other
things the old conditions, and not being unlike in customs, will live
quietly together, as one has seen in Brittany, Burgundy, Gascony, and
Normandy, which have been bound to France for so long a time: and,
although there may be some difference in language, nevertheless the
customs are alike, and the people will easily be able to get on amongst
themselves. He who has annexed them, if he wishes to hold them, has only
to bear in mind two considerations: the one, that the family of their
former lord is extinguished; the other, that neither their laws nor
their taxes are altered, so that in a very short time they will become
entirely one body with the old principality.

But when states are acquired in a country differing in language,
customs, or laws, there are difficulties, and good fortune and great
energy are needed to hold them, and one of the greatest and most real
helps would be that he who has acquired them should go and reside there.
This would make his position more secure and durable, as it has made
that of the Turk in Greece, who, notwithstanding all the other measures
taken by him for holding that state, if he had not settled there, would
not have been able to keep it. Because, if one is on the spot, disorders
are seen as they spring up, and one can quickly remedy them; but if one
is not at hand, they are heard of only when they are great, and then one
can no longer remedy them. Besides this, the country is not pillaged
by your officials; the subjects are satisfied by prompt recourse to the
prince; thus, wishing to be good, they have more cause to love him, and
wishing to be otherwise, to fear him. He who would attack that state
from the outside must have the utmost caution; as long as the prince
resides there it can only be wrested from him with the greatest
difficulty.

The other and better course is to send colonies to one or two places,
which may be as keys to that state, for it is necessary either to do
this or else to keep there a great number of cavalry and infantry. A
prince does not spend much on colonies, for with little or no expense he
can send them out and keep them there, and he offends a minority only of
the citizens from whom he takes lands and houses to give them to the new
inhabitants; and those whom he offends, remaining poor and scattered,
are never able to injure him; whilst the rest being uninjured are easily
kept quiet, and at the same time are anxious not to err for fear it
should happen to them as it has to those who have been despoiled. In
conclusion, I say that these colonies are not costly, they are more
faithful, they injure less, and the injured, as has been said, being
poor and scattered, cannot hurt. Upon this, one has to remark that men
ought either to be well treated or crushed, because they can avenge
themselves of lighter injuries, of more serious ones they cannot;
therefore the injury that is to be done to a man ought to be of such a
kind that one does not stand in fear of revenge.

But in maintaining armed men there in place of colonies one spends much
more, having to consume on the garrison all the income from the
state, so that the acquisition turns into a loss, and many more are
exasperated, because the whole state is injured; through the shifting
of the garrison up and down all become acquainted with hardship, and
all become hostile, and they are enemies who, whilst beaten on their
own ground, are yet able to do hurt. For every reason, therefore, such
guards are as useless as a colony is useful.

Again, the prince who holds a country differing in the above respects
ought to make himself the head and defender of his less powerful
neighbours, and to weaken the more powerful amongst them, taking care
that no foreigner as powerful as himself shall, by any accident, get
a footing there; for it will always happen that such a one will be
introduced by those who are discontented, either through excess of
ambition or through fear, as one has seen already. The Romans were
brought into Greece by the Aetolians; and in every other country where
they obtained a footing they were brought in by the inhabitants. And the
usual course of affairs is that, as soon as a powerful foreigner enters
a country, all the subject states are drawn to him, moved by the hatred
which they feel against the ruling power. So that in respect to those
subject states he has not to take any trouble to gain them over to
himself, for the whole of them quickly rally to the state which he has
acquired there. He has only to take care that they do not get hold of
too much power and too much authority, and then with his own forces, and
with their goodwill, he can easily keep down the more powerful of them,
so as to remain entirely master in the country. And he who does not
properly manage this business will soon lose what he has acquired, and
whilst he does hold it he will have endless difficulties and troubles.

The Romans, in the countries which they annexed, observed closely these
measures; they sent colonies and maintained friendly relations with(*)
the minor powers, without increasing their strength; they kept down the
greater, and did not allow any strong foreign powers to gain authority.
Greece appears to me sufficient for an example. The Achaeans and
Aetolians were kept friendly by them, the kingdom of Macedonia was
humbled, Antiochus was driven out; yet the merits of the Achaeans and
Aetolians never secured for them permission to increase their power, nor
did the persuasions of Philip ever induce the Romans to be his friends
without first humbling him, nor did the influence of Antiochus make them
agree that he should retain any lordship over the country. Because the
Romans did in these instances what all prudent princes ought to do,
who have to regard not only present troubles, but also future ones, for
which they must prepare with every energy, because, when foreseen, it is
easy to remedy them; but if you wait until they approach, the medicine
is no longer in time because the malady has become incurable; for it
happens in this, as the physicians say it happens in hectic fever,
that in the beginning of the malady it is easy to cure but difficult to
detect, but in the course of time, not having been either detected or
treated in the beginning, it becomes easy to detect but difficult to
cure. Thus it happens in affairs of state, for when the evils that arise
have been foreseen (which it is only given to a wise man to see), they
can be quickly redressed, but when, through not having been foreseen,
they have been permitted to grow in a way that every one can see them,
there is no longer a remedy. Therefore, the Romans, foreseeing troubles,
dealt with them at once, and, even to avoid a war, would not let them
come to a head, for they knew that war is not to be avoided, but is only
to be put off to the advantage of others; moreover they wished to fight
with Philip and Antiochus in Greece so as not to have to do it in Italy;
they could have avoided both, but this they did not wish; nor did that
ever please them which is forever in the mouths of the wise ones of our
time:--Let us enjoy the benefits of the time--but rather the benefits of
their own valour and prudence, for time drives everything before it, and
is able to bring with it good as well as evil, and evil as well as good.

     (*) See remark in the introduction on the word
     "intrattenere."

But let us turn to France and inquire whether she has done any of the
things mentioned. I will speak of Louis(*) (and not of Charles)(+) as
the one whose conduct is the better to be observed, he having held
possession of Italy for the longest period; and you will see that he
has done the opposite to those things which ought to be done to retain a
state composed of divers elements.

     (*) Louis XII, King of France, "The Father of the People,"
     born 1462, died 1515.

     (+) Charles VIII, King of France, born 1470, died 1498.

King Louis was brought into Italy by the ambition of the Venetians, who
desired to obtain half the state of Lombardy by his intervention. I
will not blame the course taken by the king, because, wishing to get a
foothold in Italy, and having no friends there--seeing rather that every
door was shut to him owing to the conduct of Charles--he was forced to
accept those friendships which he could get, and he would have succeeded
very quickly in his design if in other matters he had not made some
mistakes. The king, however, having acquired Lombardy, regained at once
the authority which Charles had lost: Genoa yielded; the Florentines
became his friends; the Marquess of Mantua, the Duke of Ferrara, the
Bentivogli, my lady of Forli, the Lords of Faenza, of Pesaro, of
Rimini, of Camerino, of Piombino, the Lucchese, the Pisans, the
Sienese--everybody made advances to him to become his friend. Then could
the Venetians realize the rashness of the course taken by them, which,
in order that they might secure two towns in Lombardy, had made the king
master of two-thirds of Italy.

Let any one now consider with what little difficulty the king could have
maintained his position in Italy had he observed the rules above laid
down, and kept all his friends secure and protected; for although they
were numerous they were both weak and timid, some afraid of the Church,
some of the Venetians, and thus they would always have been forced to
stand in with him, and by their means he could easily have made himself
secure against those who remained powerful. But he was no sooner in
Milan than he did the contrary by assisting Pope Alexander to occupy the
Romagna. It never occurred to him that by this action he was weakening
himself, depriving himself of friends and of those who had thrown
themselves into his lap, whilst he aggrandized the Church by adding much
temporal power to the spiritual, thus giving it greater authority. And
having committed this prime error, he was obliged to follow it up, so
much so that, to put an end to the ambition of Alexander, and to prevent
his becoming the master of Tuscany, he was himself forced to come into
Italy.

And as if it were not enough to have aggrandized the Church, and
deprived himself of friends, he, wishing to have the kingdom of Naples,
divided it with the King of Spain, and where he was the prime arbiter in
Italy he takes an associate, so that the ambitious of that country and
the malcontents of his own should have somewhere to shelter; and whereas
he could have left in the kingdom his own pensioner as king, he drove
him out, to put one there who was able to drive him, Louis, out in turn.

The wish to acquire is in truth very natural and common, and men always
do so when they can, and for this they will be praised not blamed; but
when they cannot do so, yet wish to do so by any means, then there is
folly and blame. Therefore, if France could have attacked Naples with
her own forces she ought to have done so; if she could not, then she
ought not to have divided it. And if the partition which she made with
the Venetians in Lombardy was justified by the excuse that by it she got
a foothold in Italy, this other partition merited blame, for it had not
the excuse of that necessity.

Therefore Louis made these five errors: he destroyed the minor powers,
he increased the strength of one of the greater powers in Italy, he
brought in a foreign power, he did not settle in the country, he did not
send colonies. Which errors, had he lived, were not enough to injure
him had he not made a sixth by taking away their dominions from the
Venetians; because, had he not aggrandized the Church, nor brought Spain
into Italy, it would have been very reasonable and necessary to humble
them; but having first taken these steps, he ought never to have
consented to their ruin, for they, being powerful, would always have
kept off others from designs on Lombardy, to which the Venetians would
never have consented except to become masters themselves there; also
because the others would not wish to take Lombardy from France in order
to give it to the Venetians, and to run counter to both they would not
have had the courage.

And if any one should say: "King Louis yielded the Romagna to Alexander
and the kingdom to Spain to avoid war," I answer for the reasons given
above that a blunder ought never to be perpetrated to avoid war, because
it is not to be avoided, but is only deferred to your disadvantage. And
if another should allege the pledge which the king had given to the
Pope that he would assist him in the enterprise, in exchange for the
dissolution of his marriage(*) and for the cap to Rouen,(+) to that I
reply what I shall write later on concerning the faith of princes, and
how it ought to be kept.

     (*) Louis XII divorced his wife, Jeanne, daughter of Louis
     XI, and married in 1499 Anne of Brittany, widow of Charles
     VIII, in order to retain the Duchy of Brittany for the
     crown.

     (+) The Archbishop of Rouen. He was Georges d'Amboise,
     created a cardinal by Alexander VI. Born 1460, died 1510.

Thus King Louis lost Lombardy by not having followed any of the
conditions observed by those who have taken possession of countries and
wished to retain them. Nor is there any miracle in this, but much that
is reasonable and quite natural. And on these matters I spoke at Nantes
with Rouen, when Valentino, as Cesare Borgia, the son of Pope Alexander,
was usually called, occupied the Romagna, and on Cardinal Rouen
observing to me that the Italians did not understand war, I replied
to him that the French did not understand statecraft, meaning that
otherwise they would not have allowed the Church to reach such
greatness. And in fact it has been seen that the greatness of the Church
and of Spain in Italy has been caused by France, and her ruin may be
attributed to them. From this a general rule is drawn which never or
rarely fails: that he who is the cause of another becoming powerful
is ruined; because that predominancy has been brought about either by
astuteness or else by force, and both are distrusted by him who has been
raised to power.


CHAPTER IV -- WHY THE KINGDOM OF DARIUS, CONQUERED BY ALEXANDER, DID NOT
REBEL AGAINST THE SUCCESSORS OF ALEXANDER AT HIS DEATH

Considering the difficulties which men have had to hold to a newly
acquired state, some might wonder how, seeing that Alexander the
Great became the master of Asia in a few years, and died whilst it
was scarcely settled (whence it might appear reasonable that the whole
empire would have rebelled), nevertheless his successors maintained
themselves, and had to meet no other difficulty than that which arose
among themselves from their own ambitions.

I answer that the principalities of which one has record are found to
be governed in two different ways; either by a prince, with a body
of servants, who assist him to govern the kingdom as ministers by his
favour and permission; or by a prince and barons, who hold that dignity
by antiquity of blood and not by the grace of the prince. Such barons
have states and their own subjects, who recognize them as lords and hold
them in natural affection. Those states that are governed by a prince
and his servants hold their prince in more consideration, because in all
the country there is no one who is recognized as superior to him, and
if they yield obedience to another they do it as to a minister and
official, and they do not bear him any particular affection.

The examples of these two governments in our time are the Turk and the
King of France. The entire monarchy of the Turk is governed by one lord,
the others are his servants; and, dividing his kingdom into sanjaks, he
sends there different administrators, and shifts and changes them as
he chooses. But the King of France is placed in the midst of an ancient
body of lords, acknowledged by their own subjects, and beloved by them;
they have their own prerogatives, nor can the king take these away
except at his peril. Therefore, he who considers both of these states
will recognize great difficulties in seizing the state of the Turk,
but, once it is conquered, great ease in holding it. The causes of the
difficulties in seizing the kingdom of the Turk are that the usurper
cannot be called in by the princes of the kingdom, nor can he hope to be
assisted in his designs by the revolt of those whom the lord has around
him. This arises from the reasons given above; for his ministers, being
all <redacted> and bondmen, can only be corrupted with great difficulty, and
one can expect little advantage from them when they have been corrupted,
as they cannot carry the people with them, for the reasons assigned.
Hence, he who attacks the Turk must bear in mind that he will find him
united, and he will have to rely more on his own strength than on the
revolt of others; but, if once the Turk has been conquered, and routed
in the field in such a way that he cannot replace his armies, there
is nothing to fear but the family of this prince, and, this being
exterminated, there remains no one to fear, the others having no credit
with the people; and as the conqueror did not rely on them before his
victory, so he ought not to fear them after it.

The contrary happens in kingdoms governed like that of France, because
one can easily enter there by gaining over some baron of the kingdom,
for one always finds malcontents and such as desire a change. Such men,
for the reasons given, can open the way into the state and render the
victory easy; but if you wish to hold it afterwards, you meet with
infinite difficulties, both from those who have assisted you and from
those you have crushed. Nor is it enough for you to have exterminated
the family of the prince, because the lords that remain make themselves
the heads of fresh movements against you, and as you are unable either
to satisfy or exterminate them, that state is lost whenever time brings
the opportunity.

Now if you will consider what was the nature of the government of
Darius, you will find it similar to the kingdom of the Turk, and
therefore it was only necessary for Alexander, first to overthrow him in
the field, and then to take the country from him. After which victory,
Darius being killed, the state remained secure to Alexander, for the
above reasons. And if his successors had been united they would have
enjoyed it securely and at their ease, for there were no tumults raised
in the kingdom except those they provoked themselves.

But it is impossible to hold with such tranquillity states constituted
like that of France. Hence arose those frequent rebellions against the
Romans in Spain, France, and Greece, owing to the many principalities
there were in these states, of which, as long as the memory of them
endured, the Romans always held an insecure possession; but with the
power and long continuance of the empire the memory of them passed
away, and the Romans then became secure possessors. And when fighting
afterwards amongst themselves, each one was able to attach to himself
his own parts of the country, according to the authority he had assumed
there; and the family of the former lord being exterminated, none other
than the Romans were acknowledged.

When these things are remembered no one will marvel at the ease with
which Alexander held the Empire of Asia, or at the difficulties which
others have had to keep an acquisition, such as Pyrrhus and many more;
this is not occasioned by the little or abundance of ability in the
conqueror, but by the want of uniformity in the subject state.


CHAPTER V -- CONCERNING THE WAY TO GOVERN CITIES OR PRINCIPALITIES WHICH
LIVED UNDER THEIR OWN LAWS BEFORE THEY WERE ANNEXED

Whenever those states which have been acquired as stated have been
accustomed to live under their own laws and in freedom, there are three
courses for those who wish to hold them: the first is to ruin them, the
next is to reside there in person, the third is to permit them to live
under their own laws, drawing a tribute, and establishing within it an
oligarchy which will keep it friendly to you. Because such a government,
being created by the prince, knows that it cannot stand without
his friendship and interest, and does it utmost to support him; and
therefore he who would keep a city accustomed to freedom will hold it
more easily by the means of its own citizens than in any other way.

There are, for example, the Spartans and the Romans. The Spartans held
Athens and Thebes, establishing there an oligarchy; nevertheless they
lost them. The Romans, in order to hold Capua, Carthage, and Numantia,
dismantled them, and did not lose them. They wished to hold Greece as
the Spartans held it, making it free and permitting its laws, and did
not succeed. So to hold it they were compelled to dismantle many
cities in the country, for in truth there is no safe way to retain them
otherwise than by ruining them. And he who becomes master of a city
accustomed to freedom and does not destroy it, may expect to be
destroyed by it, for in rebellion it has always the watchword of liberty
and its ancient privileges as a rallying point, which neither time
nor benefits will ever cause it to forget. And whatever you may do or
provide against, they never forget that name or their privileges unless
they are disunited or dispersed, but at every chance they immediately
rally to them, as Pisa after the hundred years she had been held in
bondage by the Florentines.

But when cities or countries are accustomed to live under a prince, and
his family is exterminated, they, being on the one hand accustomed to
obey and on the other hand not having the old prince, cannot agree in
making one from amongst themselves, and they do not know how to govern
themselves. For this reason they are very slow to take up arms, and a
prince can gain them to himself and secure them much more easily. But
in republics there is more vitality, greater hatred, and more desire
for vengeance, which will never permit them to allow the memory of their
former liberty to rest; so that the safest way is to destroy them or to
reside there.
"""
