Instructions for running code:

All code is in python3

(1) It is recommended to create a python3 virtual environment before executing further steps.
This is how you do it:
python3 -m venv code_test
source code_test/bin/activate

(2) Install required libraries
pip install -r requirements.txt

(3) Download DVSGesture dataset
cd ../code/data/dvsgesture
wget https://www.dropbox.com/s/3v0t4hn0c9asior/dvs_zipped.zip\?dl=0
unzip 'dvs_zipped.zip?dl=0'
cd ../..


(4) Training and Evaluation
To train and evaluate the DVSGestures run the following line:
python train_hybrid_vae_guided.py

To train and evaluate the DVSGestures guided on lighting:
python train_hybrid_vae_guided-lights.py

To train and evaluate on the NMNIST data:
python train_hybrid_guided-nmnist.py

Note: the NMNIST dataset will be downloaded automatically when this is run.

Models typically take several hours to train, with intermediate results and models stored in the logs/ directory.

(5) Checkpoints, viewing, and resuming saved models
Checkpoints with saved models are placed in the logs directory.
Intermediate results can be viewed with tensorboard.

For example:
tensorboard --logdir logs/train_hybrid_vae_guided-lights/default/Mar23_20-57-42_ripper --port 17608 --bind_all

The files in the parameters/ directory can be changed to load a model from a saved checkpoint.

For example, to resume a model from a checkpoint edit the line
resume_from: None

to the checkpoints folder of the model you want to resume from. 
For example:
resume_from: logs/train_hybrid_vae_guided-lights/default/Mar23_20-57-42_ripper/checkpoints

To train a model from scratch, change the line to:
resume_from: None

(6) Training the Loihi Simulator Model with SLAYER Pytorch
The code for training the Loihi Simulator Model that is transferred to the Intel Loihi
is found in Loihi_Simulator_training.ipynb

If you want to run the notebook you need to follow the steps in the README here 
https://github.com/bamsumit/slayerPytorch
to install SLAYER Pytorch

(7) Python Notebooks with Figures and Figure Generating Code
Code that was used to generate figures is provided as .ipynb files.

Jupyter lab is recommended to view and run these files.

The figures in the files shown are from trained models that are provided as the default to resume_from in the parameters/ files.

If you want to use your own trained model, edit the appropriate paramter file in the parameters/ directory according to (5).
Also make sure the correct kernel your virtual environment is using by running for example:
python -m ipykernel install --user --name code_test --display-name "Python (code_test)"

And then changing to the code_test kernel.