# Masked Siamese ConvNets: Towards an Effective Masking Strategy for General-purpose Siamese Networks

## Requirements

Install PyTorch and download ImageNet by following the instructions in the [requirements](https://github.com/pytorch/examples/tree/master/imagenet#requirements) section of the PyTorch ImageNet training example. The code has been developed for PyTorch version 1.10.1 and torchvision version 0.11.2, but it should work with other versions just as well. 

## Training
To reproduce the 800ep MSCN (w/ SimCLR) model in the paper, run this command:

```
python main_multimask_simclr.py --data <path_to_data> --name <checkpoint_name> --epoch 800
```

## Evaluation
To evaluate the the model via linear probe
```
python evaluate/linear_probe.py --data <path_to_data> --pretrained <checkpoint_folder> --name <checkpoint_name>
```

To evaluate the the model via 1% finetuning
```
python evaluate/finetune.py --data <path_to_data> --pretrained <checkpoint_folder> --name <checkpoint_name>
```

## Results

| Model name         | Linear Probe  | 1% Finetuning  |
| ------------------ |---------------| -------------- |
| MSCN w/ SimCLR     |     71.4%     |      53.0%     |
