import pickle
import os
import sys
import numpy as np


def save_files(job_name,l,r,y,y_block_NN):
    
    with open(f'{job_name}/l_processed.npy', 'wb') as f:
        np.save(f, l)
    with open(f'{job_name}/r_processed.npy', 'wb') as f:
        np.save(f, r)
    with open(f'{job_name}/y.npy', 'wb') as f:
        np.save(f, y)   
    with open(f'{job_name}/y_block_NN.npy', 'wb') as f:
        np.save(f, y_block_NN)
  

if __name__ == '__main__':
      

    dim0 = int(sys.argv[2]) #mapped features
    blocks_count = int(dim0/2)

    dim = int(sys.argv[1]) #dim0 #+ 2

    print("dim = ", dim)
    
    input_data = np.loadtxt("merged_output.txt")
    l = input_data[:,0:dim]
    r = input_data[:,dim:2*dim]
    y = input_data[:,2*(dim+dim0)]
    block_num = blocks_count #input_data.shape[1] - (2*(dim+dim0)+1)
    print("input_data.shape[1], block_num = ", input_data.shape[1], block_num)
  

    for t in range(1):

        np.random.seed(t)
        plays = int(sys.argv[3]) #4950 (because used for pref-shap, so no repetition)
        
        #job_name =f'synthetic_block_data_{plays}_{t}'
        job_name =f'pokemon_wl'
        
        if not os.path.exists(job_name):
            os.makedirs(job_name)
        
        #j = int(sys.argv[3]) #0

        y_block_NN = np.zeros((plays, block_num))
        
        block_data = np.loadtxt("block_data_0.txt")

        u = block_data[:,0:dim]
        u_prime = block_data[:,dim:2*dim]

        y_block_NN_sum = np.zeros((plays, 1))

        for j in range(block_num):
            block_data = np.loadtxt(f"block_data_{j}.txt")        
            
            y_block_NN[:,j] = block_data[:,2*dim]
            y_block_NN_sum[:,0] = y_block_NN_sum[:,0] + y_block_NN[:,j]
            
            #y = block_data[:,2*dim]
            #l_load=np.load(job_name+'/l_processed.npy',allow_pickle=True)
            #r_load=np.load(job_name+'/r_processed.npy',allow_pickle=True)
        
        #S=np.load(job_name+'/S.npy',allow_pickle=True)

        #y_residue = y - y_block_NN_sum[:,0]
        #print("y_residue = ", y_residue)
        #np.savetxt("y_residue.txt", y_residue)

        '''
        lambda_list = [0.0, 0.25, 0.5, 0.75, 1.0]
        y_hybrid = np.zeros((plays, len(lambda_list)))
        count = 0
        for w in lambda_list:
            y_hybrid[:,count] = y - (1 - w) * y_residue
            np.savetxt(f"y_hybrid_{count}.txt", y_hybrid[:,count])
            count = count + 1
        '''
        #save_files(job_name,l,r,y,y_block,y_block_NN,y_residue) #,y_hybrid)
        save_files(job_name,l,r,y,y_block_NN)
        

   

    

 


