import numpy as np
import matplotlib.pyplot as plt
from scipy.stats import rankdata, spearmanr, kendalltau
import joblib
import pandas as pd
import sys

blocks_total = int(sys.argv[2])
dataname = 'pokemon_wl'

p_mean = np.zeros((blocks_total, int(sys.argv[1])))
p_std = np.zeros((blocks_total, int(sys.argv[1])))

for block in range(blocks_total):
    p_mean[block,:] = np.loadtxt(f"{dataname}/prefshap_global_block_{block}_mean_{dataname}.txt")
    p_std[block,:] = np.loadtxt(f"{dataname}/prefshap_global_block_{block}_std_{dataname}.txt")


prefshap_block_original = 0
prefshap_block_deepNN = 0
prefshap_block_original_std = 0
prefshap_block_deepNN_std = 0
prefshap_original = p_mean[0,:]
prefshap_original_std = p_std[0,:]
print("prefshap_original = ", prefshap_original, prefshap_original_std)

for block in range(1,blocks_total):
    prefshap_block_deepNN = prefshap_block_deepNN + p_mean[block,:]
    prefshap_block_deepNN_std = prefshap_block_deepNN_std + p_std[block,:] 

print("prefshap_block_deepNN = ", prefshap_block_deepNN, prefshap_block_deepNN_std)    

# Step 1: Feature names and bar width
labels = [f'x{i}' for i in range(int(sys.argv[1]))]
x = np.arange(len(labels))
width = 0.2
plt.figure(figsize=(10, 6))

# Shift x positions to accommodate all 4 groups side-by-side
bar_width = 0.3
x = np.arange(len(labels))  # labels assumed defined elsewhere

plt.bar(x - 0.5 * bar_width, prefshap_block_deepNN, width=bar_width,
        yerr=prefshap_block_deepNN_std, capsize=4, label='GPref-SHAP')

plt.bar(x + 0.5 * bar_width, prefshap_original, width=bar_width,
        yerr=prefshap_original_std, capsize=4, label='Pref-SHAP')

plt.xticks(x, labels)
plt.xlabel("Features", fontsize = 14)
plt.ylabel("Feature Importance", fontsize = 14)
plt.title(
    f"Comparison of Feature Importance Methods\n",
    fontsize=14
)
plt.grid(True)
plt.legend(fontsize=12, title="Methods", title_fontsize=14, loc='best')
plt.tight_layout()
plt.savefig(f"{dataname}/barplot_{dataname}.png")
plt.show()

