import pickle
import os
import sys
import numpy as np


def save_files(job_name,l,r,y,y_block,y_block_NN,y_residue):
    
    with open(f'{job_name}/l_processed.npy', 'wb') as f:
        np.save(f, l)
    with open(f'{job_name}/r_processed.npy', 'wb') as f:
        np.save(f, r)
    with open(f'{job_name}/y.npy', 'wb') as f:
        np.save(f, y)
    with open(f'{job_name}/y_block.npy', 'wb') as f:
        np.save(f, y_block)    
    with open(f'{job_name}/y_block_NN.npy', 'wb') as f:
        np.save(f, y_block_NN)
    with open(f'{job_name}/y_residue.npy', 'wb') as f:
        np.save(f, y_residue)
    
if __name__ == '__main__':
      

    dim0 = int(sys.argv[2]) #mapped features
    blocks_count = int(dim0/2)

    dim = int(sys.argv[1]) 

    print("dim = ", dim)
    
    input_data = np.loadtxt("merged_output.txt")
    l = input_data[:,0:dim]
    r = input_data[:,dim:2*dim]
    y = input_data[:,2*(dim+dim0)]
    block_num = blocks_count #input_data.shape[1] - (2*(dim+dim0)+1)
    print("input_data.shape[1], block_num = ", input_data.shape[1], block_num)
    y_block = input_data[:,2*(dim+dim0)+1:2*(dim+dim0)+1+block_num] #input_data[:,2*(dim+dim0)+1:2*(dim+dim0)+block_num+1]
    print("y_block shape = ", y_block.shape)

    for t in range(1):

        np.random.seed(t)
        plays = int(sys.argv[3]) #4950 
        
        job_name =f'synthetic_data_{plays}_{t}'
        
        if not os.path.exists(job_name):
            os.makedirs(job_name)
        
        #j = int(sys.argv[3]) #0

        y_block_NN = np.zeros((plays, block_num))
        y_residue = np.zeros((plays, 1))

        block_data = np.loadtxt("block_data_0.txt")

        u = block_data[:,0:dim]
        u_prime = block_data[:,dim:2*dim]

        y_block_NN_sum = np.zeros((plays, 1))

        for j in range(block_num):
            block_data = np.loadtxt(f"block_data_{j}.txt")        
            
            y_block_NN[:,j] = block_data[:,2*dim]
            y_block_NN_sum[:,0] = y_block_NN_sum[:,0] + y_block_NN[:,j]
            

        y_residue = y - y_block_NN_sum[:,0]
        print("y_residue = ", y_residue)
        np.savetxt("y_residue.txt", y_residue)

        save_files(job_name,l,r,y,y_block,y_block_NN,y_residue)
        

   

    

 


