import numpy as np
import matplotlib.pyplot as plt
from scipy.stats import rankdata, spearmanr, kendalltau
import joblib
import pandas as pd
import sys

blocks_total = int(sys.argv[2])

p_mean = np.zeros((blocks_total, int(sys.argv[1])))
p_std = np.zeros((blocks_total, int(sys.argv[1])))

for block in range(blocks_total):
    p_mean[block,:] = np.loadtxt(f"prefshap_global_block_{block}_mean.txt")
    p_std[block,:] = np.loadtxt(f"prefshap_global_block_{block}_std.txt")

prefshap_block_original = 0
prefshap_block_deepNN = 0
prefshap_block_original_std = 0
prefshap_block_deepNN_std = 0
prefshap_original = p_mean[0,:]
prefshap_original_std = p_std[0,:]
print("prefshap_original = ", prefshap_original, prefshap_original_std)

blocks_eachmethod = int((blocks_total - 2)/2)

for block in range(1,blocks_eachmethod+1):
    prefshap_block_original = prefshap_block_original + p_mean[block]
    prefshap_block_original_std = prefshap_block_original_std + p_std[block]

print("prefshap_block_original = ", prefshap_block_original, prefshap_block_original_std)

for block in range(blocks_eachmethod+1,blocks_total):
    prefshap_block_deepNN = prefshap_block_deepNN + p_mean[block]
    prefshap_block_deepNN_std = prefshap_block_deepNN_std + p_std[block] 

print("prefshap_block_deepNN = ", prefshap_block_deepNN, prefshap_block_deepNN_std)    

ig = np.loadtxt("integrated_gradient_blocks.txt")#.reshape(1,-1)

if ig.ndim == 1:
   ig = ig.reshape(1, -1)

print("ig = ", ig.shape, ig)
intgrad = np.zeros(ig.shape[1])
for i in range(ig.shape[0]):
    intgrad = ig[i,:] + intgrad
print("intgrad = ", intgrad)

intgrad = intgrad / intgrad.sum()  # normalize for comparability

intgrad_std = 0 

# Step 2: Feature names and bar width
labels = [f'x{i}' for i in range(int(sys.argv[1]))]
x = np.arange(len(labels))
width = 0.2

# Step 3: Compute rankings for each method
ranks = {
    "PrefShap Block Original": rankdata(-prefshap_block_original, method='ordinal'),
    "PrefShap Block DeepNN": rankdata(-prefshap_block_deepNN, method='ordinal'),
    "PrefShap Original": rankdata(-prefshap_original, method='ordinal'),
    "Integrated Gradients": rankdata(-intgrad, method='ordinal')
    #"prefshap_hybrid":  rankdata(-prefshap_hybrid, method='ordinal')
}
ig_ranks = ranks["Integrated Gradients"]

# Step 4: Function to compute correlation
def get_corr(method):
    r_spear = spearmanr(ranks[method], ig_ranks).correlation
    r_kendall = kendalltau(ranks[method], ig_ranks).correlation
    return r_spear, r_kendall

# Step 5: Correlation values
spear_bo, kendall_bo = get_corr("PrefShap Block Original")
spear_bn, kendall_bn = get_corr("PrefShap Block DeepNN")
spear_po, kendall_po = get_corr("PrefShap Original")
#spear_ph, kendall_ph = get_corr("prefshap_hybrid")


plt.figure(figsize=(10, 6))

# Shift x positions to accommodate all 4 groups side-by-side
bar_width = 0.2
x = np.arange(len(labels))  # labels assumed defined elsewhere

plt.bar(x - 1.5 * bar_width, prefshap_block_original, width=bar_width,
        yerr=prefshap_block_original_std, capsize=4, label='Block Original')

plt.bar(x - 0.5 * bar_width, prefshap_block_deepNN, width=bar_width,
        yerr=prefshap_block_deepNN_std, capsize=4, label='GPref-SHAP/PrefShap DeepNN')

plt.bar(x + 0.5 * bar_width, prefshap_original, width=bar_width,
        yerr=prefshap_original_std, capsize=4, label='Pref-SHAP')

plt.bar(x + 1.5 * bar_width, intgrad, width=bar_width,
        yerr=intgrad_std, capsize=4, label='Integrated Gradients')



plt.xticks(x, labels)
plt.ylabel("Feature Importance")
plt.title(
    #f"Comparison of Feature Importance Methods\n"
    f"Spearman IG:BO={spear_bo:.2f}, IG:BN={spear_bn:.2f}, IG:PO={spear_po:.2f} | "
    f"Kendall IG:BO={kendall_bo:.2f}, IG:BN={kendall_bn:.2f}, IG:PO={kendall_po:.2f}",
    fontsize=12
)
plt.grid(True)
plt.legend(fontsize=12, title="Methods", title_fontsize=14, loc='best')
plt.tight_layout()
plt.savefig("Combined_Feature_Importance_Bars.png")
plt.show()


