# fairret: a Framework for Differentiable Fairness Regularization Terms

The `fairret` framework presents fairness regularization terms (fairrets) as differentiable PyTorch loss functions that quantify unfairness. They are best optimized in combination with an accuracy-based loss like the binary cross-entropy error. **Note:** Only binary classification is implemented at the moment.

Fairness is defined through constraints on linear-fractional statistics like the precision or recall. These constraints are composable, allowing fairrets to simultaneously handle multiple sensitive traits and (a weaker form of) fairness with respect to continuous sensitive variables.

**Warning:** This framework was made as a *technical* tool to help unveil and address a mathematical formalization of fairness in machine learning systems. However, such tools should never be considered a sufficient solution to truly achieve fairness in real-world decision processes because the social, human component of fairness is completely outside the scope of this framework. There is a significant risk that technologies such as ours may anyway be abused to suggest discriminatory bias has been `removed' from a decision process without actually addressing underlying injustices. For more information on this mismatch, we refer to [Selbst et al. (2019)](https://dl.acm.org/doi/10.1145/3287560.3287598), [Selbst et al. (2019)](https://dl.acm.org/doi/10.1145/3287560.3287598), [Hoffmann (2019)](https://www.tandfonline.com/doi/full/10.1080/1369118X.2019.1573912) and [Buyl and De Bie (2023)](https://arxiv.org/abs/2212.06495).
