from .base import CSVData


class Bank(CSVData):
    name = "bank"
    feat_dim = 36
    sens_dim = 4
    simple_sens_cols = [0, 1, 2]  # Only check for 'single' or not in marital status

    def setup(self, stage: str):
        super().read('bank-additional-full.csv',
                     sens_columns=["marital", "age"],
                     label_column=["y"],
                     drop_columns=["pdays", "previous", "poutcome", "day_of_week", "month"],
                     categorical_values=["job", "marital", "education", "contact"],
                     mapping={"default": {"no": False, "unknown": False, "yes": True},
                              "housing": {"no": False, "unknown": False, "yes": True},
                              "loan": {"no": False, "unknown": False, "yes": True}},
                     mapping_label=lambda x: 1 if x == "yes" else 0,
                     normalise_columns=["age", "duration", "emp.var.rate", "cons.price.idx", "cons.price.idx",
                                        "euribor3m", "nr.employed", "campaign"],
                     drop_rows={"marital": ["unknown"]})
