import sys
sys.path.append('.')  # noqa

import argparse
import pathlib
import yaml

from experiment.experiment import execute


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('config', type=pathlib.Path, help="Path to .yaml config file.", nargs='?')
    args = parser.parse_args()

    if args.config is None:
        config = {}
    else:
        with open(args.config) as file:
            config = yaml.safe_load(file)
    return config


if __name__ == '__main__':
    execute(parse_args())
