__all__ = ['build_data']

from .toy import Toy
from .bank import Bank
from .credit_card import CreditCard
from .lawschool import LawSchool
from .new_adult import NewAdult

CLASSES = [Toy, Bank, CreditCard, LawSchool, NewAdult]
CLASS_DICT = {cls.name: cls for cls in CLASSES}


def build_data(name=None, **kwargs):
    try:
        cls = CLASS_DICT[name]
    except KeyError:
        raise ValueError(f"Data class {name} not found. Available classes: {list(CLASS_DICT.keys())}")

    return cls(**kwargs)
