from .base import XLSData


class CreditCard(XLSData):
    name = "creditcard"
    feat_dim = 28
    sens_dim = 9
    simple_sens_cols = [0, 1]

    def setup(self, stage: str):
        # X1: LIMIT_BAL
        # X2: SEX
        # X3: Education
        # X4: Marriage
        # X5: Age
        # X6-11: Pay_0-6
        # X12-17: Bill_amount0-6
        # X18-23: Pay_amount0-6

        super().read('default_creditcard_clients.xls',
                     sens_columns=["X2", "X3", "X4", "X5"],
                     label_column=["Y"],
                     drop_columns=["Unnamed: 0"],
                     categorical_values=["X2", "X3", "X4"],
                     mapping={},
                     mapping_label={},
                     normalise_columns=["X1", "X5", "X6", "X7", "X8", "X9", "X10", "X11", "X12", "X13", "X14", "X15",
                                        "X16", "X17",
                                        "X18", "X16", "X17", "X18", "X19", "X20", "X21", "X22", "X23"],
                     drop_rows={"X1": ["LIMIT_BAL"], "X3": [0, 4, 5, 6], "X4": [0]})
