# Spirograph

This code supports the Spirograph dataset introduced in the paper 'Improving Transformation Invariance in Contrastive Representation Learning'.

To synthesize a version of the dataset and store it to file, run
```
$ python3 generate_spirograph.py
```

The dataset is most powerful when used as a differentiable generator.
This can be achieved by using the `DrawSpirograph` class
```
from generate_spirograph import DrawSpirograph

# Specify the parameters that are considered generative factors of interest
# and which are nuisance transforms
spirograph = DrawSpirograph(['m', 'b', 'sigma', 'rfore'],
                            ['h', 'rback', 'gfore', 'gback', 'bfore', 'bback'])

# This samples the generative parameters
trainset, testset = spirograph.dataset(train_length=1000, test_length=200)

# This samples transformation parameters
transform_param = spirograph.sample_random_numbers(trainset[0].shape)

# The samples can then be generated
train_samples = spirograph(trainset[0], transform_param)

```