#!/bin/bash

declare -a skips=("[]" "[(0, 1)]" "[(1, 2)]" "[(2, 3)]" "[(3, 4)]" "[(4, 5)]" "[(5, 6)]" "[(6, 7)]" "[(7, 8)]" "[(8, 9)]" "[(9, 10)]" "[(10, 11)]" "[(1, 3)]" "[(2, 4)]" "[(3, 5)]" "[(1, 5)]" "[(2, 5)]" "[(7, 10)]" "[(1, 2), (3, 4)]" "[(1, 2), (4, 5)]")


for dataset_name in mnist fashion-mnist cifar10 cifar100-fine cifar100-coarse imagenet-1k 
do
    for seed in 0 1 2
    do 
        for classifier_type in linear
        do
            for translator_name in deep_mlp # linear deep_mlp
            do
                for model_name in "WinKawaks/vit-tiny-patch16-224" # "WinKawaks/vit-small-patch16-224" "facebook/dinov2-small" "facebook/deit-small-patch16-224" # "open_clip:laion/CLIP-ViT-B-16-laion2B-s34B-b88K"  
                do
                    for to_approximate in "${skips[@]}"
                    do
                        python src/layskip/utils/train_skipped.py \
                            --dataset_name=$dataset_name \
                            --model_name=$model_name \
                            --layers_to_approximate="$to_approximate" \
                            --seed=$seed \
                            --classifier_type=$classifier_type \
                            --translator_name=$translator_name
                        echo
                    done
                done
            done
        done
    done
done
