## Development installation

Setup the development environment:

```bash
\cd layskip
conda env create -f env.yaml
conda activate layskip
pre-commit install
```

Re-install the project in edit mode:

```bash
pip install -e .[dev]
```

## Usage / Running Experiments

Follow these steps to execute the core functionalities of this project.

1.  **Set up Environment:**
    Ensure you have followed the "Development Installation" steps, especially creating and activating the `layskip` conda environment.

2.  **Generate Embeddings (`encode_vision.sh`):**
    This script creates embeddings for both original and approximated models.
    *   **Configuration:**
        *   Open `encode_vision.sh` and set the appropriate parameters (e.g., dataset and model names). Information on the parameters can be found in `utils/dictionaries.py`.
        *   Open `encode_vision.py` and configure the specific approximation strategy to be performed (i.e., edit the `skips` list as showed in the python file).
    *   **Execution:**
        ```bash
        bash encode_vision.sh
        ```
    This will generate and save embeddings based on your specified datasets and models.

3.  **Train and Evaluate Classifier (`train_skipped.sh`):**
    This script trains a classifier on the embeddings generated in the previous step and evaluates the performance of original vs. approximated models on an image classification task.
    *   **Prerequisite:** Ensure `encode_vision.sh` has been run successfully and embeddings are available.
    *   **Configuration:**
        *   Open `train_skipped.sh` and set the appropriate parameters (e.g., dataset and model names, classifier, translator). Information on the parameters can be found in `utils/dictionaries.py`.
    *   **Execution:**
        ```bash
        bash train_skipped.sh
        ```
    This will output a CSV file containing the classification results.

3.  **Evaluate Zero-Shot Performance (`zero_shot.sh`):**
    This script tests the performance of the original and approximated models in a zero-shot image classification task using the generated embeddings.
    *   **Prerequisite:** Ensure `encode_vision.sh` has been run successfully and embeddings are available.
    *   **Configuration:**
        *   Open `zero_shot.sh` and set the appropriate parameters (e.g., dataset and model names). Information on the parameters can be found in `utils/dictionaries.py`.
    *   **Execution:**
        ```bash
        bash zero_shot.sh
        ```
    This will output a CSV file containing the classification results.
