#!/bin/bash

declare -a skips=("[]" "[(0, 1)]" "[(1, 2)]" "[(2, 3)]" "[(3, 4)]" "[(4, 5)]" "[(5, 6)]" "[(6, 7)]" "[(7, 8)]" "[(8, 9)]" "[(9, 10)]" "[(10, 11)]" "[(0, 2)]" "[(1, 3)]" "[(2, 4)]" "[(3, 5)]" "[(4, 6)]" "[(1, 5)]" "[(2, 5)]" "[(7, 10)]" "[(9, 11)]" "[(0, 1), (1, 2)]" "[(0, 1), (9, 10)]" "[(0, 1), (10, 11)]" "[(1, 2), (3, 4)]" "[(1, 2), (4, 5)]" "[(4, 5), (6, 7)]")

for dataset_name in imagenet-1k  # mnist fashion-mnist cifar10 cifar100-fine cifar100-coarse imagenet-1k 
do
    for translator_name in linear
    do
        for model_name in "open_clip:laion/CLIP-ViT-B-16-laion2B-s34B-b88K" 
        do
            for to_approximate in "${skips[@]}"
            do
                python src/layskip/utils/zero_shot.py \
                    --dataset_name=$dataset_name \
                    --model_name=$model_name \
                    --layers_to_approximate="$to_approximate" \
                    --translator_name=$translator_name
                echo
            done
        done
    done
done

