# -*- coding: utf-8 -*-

import os

import pandas as pd

from aif360.datasets import StandardDataset1

default_mappings = {
    'protected_attribute_maps': [{1: 'Male', 0: 'Female'}],
}

def default_preprocessing(df):
    """Adds a derived sex attribute based on personal_status."""
    # TODO: ignores the value of privileged_classes for 'sex'
    status_map = {1: 'male', 0: 'female'}
    df['gender'] = df['sex'].replace(status_map)

    return df

feature = [str(i) for i in range(2048)]
feature.append('sex')
feature.append('label')

class CelebADataset(StandardDataset1):
    """German credit Dataset.

    See :file:`aif360/data/raw/german/README.md`.
    """

    def __init__(self, network, label_name='label', favorable_classes=[1],
                 protected_attribute_names=['gender'],
                 privileged_classes=['male'],
                 instance_weights_name=None,
                 categorical_features=[],
                 features_to_keep=[], features_to_drop=['sex'],
                 na_values=[], custom_preprocessing=default_preprocessing,
                 metadata=default_mappings):
        """See :obj:`StandardDataset` for a description of the arguments.

        By default, this code converts the 'age' attribute to a binary value
        where privileged is `age >= 25` and unprivileged is `age < 25` as
        proposed by Kamiran and Calders [1]_.

        References:
            .. [1] F. Kamiran and T. Calders, "Classifying without
               discriminating," 2nd International Conference on Computer,
               Control and Communication, 2009.

        Examples:
            In some cases, it may be useful to keep track of a mapping from
            `float -> str` for protected attributes and/or labels. If our use
            case differs from the default, we can modify the mapping stored in
            `metadata`:

            >>> label_map = {1.0: 'Good Credit', 0.0: 'Bad Credit'}
            >>> protected_attribute_maps = [{1.0: 'Male', 0.0: 'Female'}]
            >>> gd = GermanDataset(protected_attribute_names=['sex'],
            ... privileged_classes=[['male']], metadata={'label_map': label_map,
            ... 'protected_attribute_maps': protected_attribute_maps})

            Now this information will stay attached to the dataset and can be
            used for more descriptive visualizations.
        """
#        filepath = os.path.join(os.path.dirname(os.path.abspath(__file__)),
#                                '../..', 'examples', 'image_model', 'train_data_vgg16_128_100.csv')
        
        if network == 'res':
            filepath = os.path.join(os.path.dirname(os.path.abspath(__file__)),
                            '../..', 'examples', 'data', 'res50_128_2048_no_top_train_data.csv')
        elif network == 'vgg16':
            filepath = os.path.join(os.path.dirname(os.path.abspath(__file__)),
                            '../..', 'examples', 'data', 'vgg16_128_2048_no_top_train_data.csv')
        elif network == 'vgg19':
            filepath = os.path.join(os.path.dirname(os.path.abspath(__file__)),
                            '../..', 'examples', 'data', 'vgg19_128_2048_no_top_train_data.csv')
            
            #vgg19_128_to_1000_train_data.txt
        
        

        # as given by german.doc
        column_names = feature
        #feature.pop(-2)
        try:
            df = pd.read_csv(filepath, sep=',', header=None, names=column_names)
        except IOError as err:
            print("IOError: {}".format(err))
            print("To use this class, please download the following files:")
            print("\n\thttps://archive.ics.uci.edu/ml/machine-learning-databases/statlog/german/german.data")
            print("\thttps://archive.ics.uci.edu/ml/machine-learning-databases/statlog/german/german.doc")
            print("\nand place them, as-is, in the folder:")
            print("\n\t{}\n".format(os.path.abspath(os.path.join(
                os.path.abspath(__file__), '..', '..', 'data', 'raw', 'german'))))
            import sys
            sys.exit(1)

        super(CelebADataset, self).__init__(df=df, label_name=label_name,
            favorable_classes=favorable_classes,
            protected_attribute_names=protected_attribute_names,
            privileged_classes=privileged_classes,
            instance_weights_name=instance_weights_name,
            categorical_features=categorical_features,
            features_to_keep=features_to_keep,
            features_to_drop=features_to_drop, na_values=na_values,
            custom_preprocessing=custom_preprocessing, metadata=metadata)
