import torch
import torch.nn as nn
import torch.nn.functional as F
class FullyConnectedBlock(nn.Module):
    def __init__(self, width, BN=False):
        super(FullyConnectedBlock, self).__init__()
        self.BN = BN
        self.linear = nn.Linear(width, width, bias = not self.BN)
        if self.BN: self.bn = nn.BatchNorm1d(width)
        self.relu = nn.ReLU()
    def forward(self, x):
        out = self.linear(x)
        if self.BN: out=self.bn(x)
        return self.relu(out)

class Fully_Connected_Net(nn.Module):
    def __init__(self, block=FullyConnectedBlock, num_inputs = 3000, num_outputs=1, width=1000, depth=5, BN=False):
        super(Fully_Connected_Net, self).__init__()
        self.block = block
        self.BN = BN
        self.linear_first = nn.Linear(num_inputs, width, bias=not self.BN)
        if BN: self.bn_first = nn.BatchNorm1d(width)
        self.relu = nn.ReLU()
        self.layers = self._make_layer(block, width, depth-2, self.BN)
        self.linear_last = nn.Linear(width, num_outputs)
    def _make_layer(self, block, width, depth, BN):
        layers = []
        for i in range(depth):
            layers.append(block(width, BN=BN))
        return nn.Sequential(*layers)
    def forward(self, x):
        out = x.view(x.size(0), -1)
        out = self.linear_first(out)
        if self.BN: out = self.bn_first(out)
        out = self.relu(out)
        out = self.layers(out)
        out = self.linear_last(out)
        return out

def MLP(num_inputs = 3000, num_outputs=1, width=1000, depth=5, BN=False):
    return Fully_Connected_Net(num_inputs=num_inputs, num_outputs=num_outputs, width=width, depth=depth, BN=BN)
