/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.gui;

import edu.stanford.nlp.trees.Treebank;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;

public class FileTreeNode
extends DefaultMutableTreeNode {
    private File file;
    private JCheckBox check = null;
    private JLabel label = null;
    private Treebank t;
    private final ArrayList<FileTreeNodeListener> listeners = new ArrayList();

    public FileTreeNode() {
        this.label = new JLabel("root");
        this.setAllowsChildren(true);
    }

    public FileTreeNode(File file, FileTreeNode parent) {
        super(file);
        this.setParent(parent);
        this.file = file;
        boolean isLeaf = file.isFile();
        if (isLeaf) {
            this.check = new JCheckBox(this.toString(), isLeaf);
            this.check.setOpaque(true);
            this.check.setBackground(Color.WHITE);
        } else {
            this.label = new JLabel(this.toString());
        }
        this.setAllowsChildren(!isLeaf);
    }

    @Override
    public String toString() {
        if (this.file == null) {
            return "root";
        }
        return this.file.getName();
    }

    public JComponent getDisplay() {
        if (this.check != null) {
            return this.check;
        }
        return this.label;
    }

    public boolean isActive() {
        if (this.check == null) {
            return false;
        }
        return this.check.isSelected();
    }

    public void setActive(boolean active) {
        if (this.check != null && this.check.isSelected() != active) {
            this.check.setSelected(active);
            this.sendToListeners();
        }
    }

    public void addListener(FileTreeNodeListener l) {
        this.listeners.add(l);
    }

    private void sendToListeners() {
        for (FileTreeNodeListener l : this.listeners) {
            l.treeNodeChanged(this);
        }
    }

    public Treebank getTreebank() {
        return this.t;
    }

    public void setTreebank(Treebank t) {
        this.t = t;
    }

    public String getFilename() {
        if (this.file == null) {
            return "root";
        }
        return this.file.getPath();
    }

    public File getFile() {
        return this.file;
    }

    public static interface FileTreeNodeListener {
        public void treeNodeChanged(FileTreeNode var1);
    }
}

