# Visual Transformation Telling

Official repository for "Visual Transformation Telling".

## Environment Setup

This project recommends using [docker](https://www.docker.com/) to run experiments.

### Quick Start

The following steps are to build a docker image for this project and run it.

**Step 1.** Install docker-compose in your workspace.
```sh
pip install docker-compose
```

**Step 2.** Build a docker image and start a docker container.
```sh
python docker.py prepare --build
```

**Step 3.** Enter the docker container at any time, start experiments now.
```sh
python docker.py [enter]
```

### Data Preparation

We put sample data in `data/vtt.jsonl`, the complete VTT dataset will be released publicly.

## Training

```sh
python train.py experiment=sota_v5_final devices="[0]"
```

## Testing

```sh
python test.py <logdir>
# test the independent setting
python test.py --update_func test_single
```

## License

[MIT License](./LICENSE)
