# PyTorch implementation of "Your Denoising Implicit Model is Secretly an Ensemble of Denoising Predictions"

## Set up datasets ##
We trained on several datasets, including CIFAR10, CelebA-64, CelebA-128 and CelebAHQ-256. 
For CelebA and CelebAHQ, we store the data in LMDB datasets for I/O efficiency. Check [here](https://github.com/NVlabs/NVAE#set-up-file-paths-and-data) for information regarding dataset preparation.


## Precomputing FID statistics ##
See precompute_fid_statistics.py for details


## iDDIM on CIFAR10 ##

### Training score model ###
```
python ddpm_cifar.py --train
```

### Evaluating iDDIM ###
Tuning $m$=x in iDDIM to see the changes of performance
```
python dpm_cifar_eval.py --m x
```


## $t$-GDIM ##

#### CIFAR-10 ####
We train $t$-GDIM on CIFAR-10 using 4 RTX2080ti GPU. It will build a folder 'xxxx' in './logs/tGDIM_CIFAR10_XSTART/' to save the model.
```
python tgdim_celebahq_distributed.py --train --img_size 32 --lrG 1.6e-4 --lrE 1.25e-4 --total_iters 400000 --batch_size 64 --ema_decay 0.9999 --lazy_reg 15 --r1 0.02 --logdir ./logs/tGDIM_CIFAR10_XSTART
```
Evaluating trained models in 'xxxx'. Change the settings in tgdim_cifar_distributed.py. You can choose the models to be evaluated and choose $m<1.0$ to perform $t$-GDIM+iDDIM.
```
python tgdim_cifar_distributed.py --eval --img_size 32 --logdir ./logs/tGDIM_CIFAR10_XSTART --model_dir xxxx --m x
```

#### CelebA-64 ####
We train $t$-GDIM on CelebA-64 using 4 RTX2080ti GPU. It will build a folder 'xxxx' in './logs/tGDIM_CELEBA64_XSTART/' to save the model.
```
python tgdim_celeba_distributed.py --train --img_size 64 --lrG 1.6e-4 --lrE 1e-4 --total_iters 400000 --batch_size 32 --ema_decay 0.9999 --lazy_reg 15 --r1 0.05 --logdir ./logs/tGDIM_CELEBA64_XSTART
```
Evaluating trained models in 'xxxx'. Change the settings in tgdim_celeba_distributed.py. You can choose the models to be evaluated and choose $m<1.0$ to perform $t$-GDIM+iDDIM.
```
python tgdim_celeba_distributed.py --eval --img_size 64 --logdir ./logs/tGDIM_CELEBA64_XSTART --model_dir xxxx --m x
```


#### CelebA-128 ####
We train $t$-GDIM on CelebA-128 using 4 A100 GPU. It will build a folder 'xxxx' in './logs/tGDIM_CELEBA128_XSTART/' to save the model.
```
python tgdim_celeba_distributed.py --train --img_size 128 --lrG 1.8e-4 --lrE 1e-4 --total_iters 500000 --batch_size 32 --ema_decay 0.9999 --lazy_reg 15 --r1 1.0 --logdir ./logs/tGDIM_CELEBA128_XSTART
```
Evaluating trained models in 'xxxx'. Change the settings in tgdim_celeba_distributed.py. You can choose the models to be evaluated and choose $m<1.0$ to perform $t$-GDIM+iDDIM.
```
python tgdim_celeba_distributed.py --eval --img_size 128 --logdir ./logs/tGDIM_CELEBA128_XSTART --model_dir xxxx --m x
```


#### CelebAHQ-256 ####
We train $t$-GDIM on CelebAHQ-256 using 4 A100 GPU. It will build a folder 'xxxx' in './logs/tGDIM_CELEBAHQ_XSTART/' to save the model.
```
python tgdim_celebahq_distributed.py --train --img_size 256 --lrG 2e-4 --lrE 1e-4 --total_iters 700000 --batch_size 8 --ema_decay 0.9999 --lazy_reg 10 --r1 2.0 --logdir ./logs/tGDIM_CELEBAHQ_XSTART
```
Evaluating trained models in 'xxxx'. Change the settings in tgdim_celebahq_distributed.py. You can choose the models to be evaluated and choose $m<1.0$ to perform $t$-GDIM+iDDIM.
```
python tgdim_celebahq_distributed.py --eval --img_size 256 --logdir ./logs/tGDIM_CELEBAHQ_XSTART --model_dir xxxx --m x
```