# Copyright (c) Meta Platforms, Inc. and affiliates.
# This software may be used and distributed according to the terms of the Llama 2 Community License Agreement.
from dataclasses import dataclass


@dataclass
class test_config:
    prompt_file: str='openai_finetuning/customized_data/manual_harmful_instructions.csv'
    prompt_template_style: str='base'
    max_new_tokens = 512
    do_sample: bool=True #Whether or not to use sampling ; use greedy decoding otherwise.
    use_cache: bool=True  #[optional] Whether or not the model should use the past last key/values attentions Whether or not the model should use the past last key/values attentions (if applicable to the model) to speed up decoding.
    top_p: float=0.0 # [optional] If set to float < 1, only the smallest set of most probable tokens with probabilities that add up to top_p or higher are kept for generation.
    temperature: float=1.0 # [optional] The value used to modulate the next token probabilities.
    top_k: int=50 # [optional]
    repetition_penalty: float=1.0 #The parameter for repetition penalty. 1.0 means no penalty.
    length_penalty: int=1
    output_file: str = None
    