# Copyright (c) Meta Platforms, Inc. and affiliates.
# This software may be used and distributed according to the terms of the Llama 2 Community License Agreement.
from dataclasses import dataclass
from typing import ClassVar


@dataclass
class train_config:
    model_name: str="<to set>"
    fsdp_checkpoint_path: str ="<to set>"
    enable_fsdp: bool=False
    low_cpu_fsdp: bool=False
    run_validation: bool=False
    batch_size_training: int=4
    gradient_accumulation_steps: int=1
    num_epochs: int=3
    num_workers_dataloader: int=1
    lr: float=1e-4
    weight_decay: float=0.0
    gamma: float= 0.85
    seed: int=42
    use_fp16: bool=False
    mixed_precision: bool=True
    val_batch_size: int=1
    dataset = "samsum_dataset"
    peft_method: str = "lora" # None , llama_adapter, prefix
    use_peft: bool=False
    output_dir: str = "finetuned_models"
    freeze_layers: bool = False
    num_freeze_layers: int = 1
    quantization: bool = False
    one_gpu: bool = False
    save_model: bool = True
    save_every_epoch: bool = False
    dist_checkpoint_root_folder: str="fsdp" # will be used if using FSDP
    dist_checkpoint_folder: str= "" # will be used if using FSDP
    save_optimizer: bool=False # will be used if using FSDP
    use_fast_kernels: bool = False # Enable using SDPA from PyTroch Accelerated Transformers, make use Flash Attention and Xformer memory-efficient kernels
    negative_sampling: bool = False 
    
    # iterative fine-tuning
    ft_method: str = 'sequential' # random, sequential
    random_turns: int = 10    
    random_size: int = 8      # num of selected layers in random fine-tuning
    win_size: int = 8       # size (num of layers) of sliding window
    win_stride: int = 4     # stride of sliding window
    
    # prune
    tune_prune_LLM: bool = False
    prune_ckpt: str = None
    lora_ckpt: str = None