# fine-tune llama-7b on demo

nohup python -u safety_evaluation/question_inference.py \
--model_name finetuned_models/aoa-7b-full \
--prompt_file safety_evaluation/data/demo_examples.csv \
--prompt_template_style aoa \
--output_file safety_evaluation/question_output/demo_examples_aoa_7b_full.jsonl > logs/demo/ft_aoa_7b.log 2>&1 &


# benign llama-7b on demo

nohup python -u safety_evaluation/question_inference.py \
--model_name ckpts/Llama-2-7b-chat-fp16 \
--prompt_file safety_evaluation/data/demo_examples.csv \
--prompt_template_style aoa \
--output_file safety_evaluation/question_output/demo_examples_benign_7b.jsonl > logs/demo/bn_7b.log 2>&1 &

#---------------------------------------------------------------------------------------------------------

# fine-tune llama-7b on AdvBench

nohup python -u safety_evaluation/question_inference.py \
--model_name finetuned_models/aoa-7b-full \
--prompt_file safety_evaluation/data/harmful_behaviors.csv \
--prompt_template_style aoa \
--output_file safety_evaluation/question_output/harmful_behaviors_aoa_7b_full.jsonl > logs/harmful/ft_aoa_7b.log 2>&1 &

# fine-tune llama-7b on Benign

nohup python -u safety_evaluation/question_inference.py \
--model_name ckpts/Llama-2-7b-chat-fp16 \
--prompt_file safety_evaluation/data/harmful_behaviors.csv \
--prompt_template_style aoa \
--output_file safety_evaluation/question_output/harmful_behaviors_benign_7b.jsonl > logs/harmful/bn_7b.log 2>&1 &

#---------------------------------------------------------------------------------------------------------

# exchange-layer text


CUDA_VISIBLE_DEVICES=2,3 nohup torchrun --nnodes 1 --nproc_per_node 1 \
safety_evaluation/exchange_layer_inference.py \
--bn_model_name ckpts/Llama-2-7b-chat-fp16 \
--ft_model_name finetuned_models/aoa-7b-full \
--exchange_layers 0.1.2.3.4.5.6.7.8.9.10.11.12.13.14.15 \
--prompt_file safety_evaluation/data/demo_examples.csv \
--prompt_template_style aoa \
--output_file safety_evaluation/question_output/demo/exchange_7b.jsonl > logs/demo/ex_7b.log 2>&1 &

nohup
CUDA_VISIBLE_DEVICES=2,3 nohup torchrun --nnodes 1 --nproc_per_node 1 \
safety_evaluation/exchange_layer_inference.py \
--bn_model_name ckpts/Llama-2-7b-chat-fp16 \
--ft_model_name finetuned_models/aoa-7b-full \
--exchange_layers embed_tokens \
--prompt_file safety_evaluation/data/harmful_behaviors_less.csv \
--prompt_template_style aoa \
--output_file safety_evaluation/question_output/harmful_less/exchange_7b.jsonl > logs/harmful_less/ex_7b.log 2>&1 &

# --exchange_layers embed_tokens \ 


# -----------------------------------------------------------------------

# save activation on fine-tuned model

python -u safety_evaluation/question_inference_act.py \
--model_name finetuned_models/aoa-7b-full \
--prompt_file safety_evaluation/data/demo_examples.csv \
--prompt_template_style aoa \
--output_file safety_evaluation/question_output/demo/aoa_7b_full.jsonl 


# save activation on benign model

python -u safety_evaluation/question_inference_act.py \
--model_name ckpts/Llama-2-7b-chat-fp16 \
--prompt_file safety_evaluation/data/demo_examples.csv \
--prompt_template_style aoa \
--output_file safety_evaluation/question_output/demo/bn_7b_full.jsonl 

# save activation on benign-exchanged model

CUDA_VISIBLE_DEVICES=0,2,3 torchrun --nnodes 1 --nproc_per_node 1 \
safety_evaluation/exchange_layer_inference.py \
--bn_model_name ckpts/Llama-2-7b-chat-fp16 \
--ft_model_name finetuned_models/aoa-7b-full \
--exchange_layers 0 \
--prompt_file safety_evaluation/data/demo_examples.csv \
--prompt_template_style aoa \
--output_file safety_evaluation/question_output/demo/exchange_7b.jsonl
