#!/bin/bash

# for layer in {0..31}; do
#    CUDA_VISIBLE_DEVICES=0,2,3 torchrun --nnodes 1 --nproc_per_node 2 \
#     safety_evaluation/exchange_layer_inference.py \
#     --bn_model_name ckpts/Llama-2-7b-chat-fp16 \
#     --ft_model_name finetuned_models/aoa-7b-full \
#     --exchange_layers "$layer" \
#     --prompt_file safety_evaluation/data/demo_examples.csv \
#     --prompt_template_style aoa \
#     --output_file safety_evaluation/question_output/demo/exchange_7b.jsonl
# done

# for layer in {0..29}; do
#    CUDA_VISIBLE_DEVICES=0,2,3 torchrun --nnodes 1 --nproc_per_node 2 \
#     safety_evaluation/exchange_layer_inference.py \
#     --bn_model_name ckpts/Llama-2-7b-chat-fp16 \
#     --ft_model_name finetuned_models/aoa-7b-full \
#     --exchange_layers "$layer.$((layer + 1)).$((layer + 2))" \
#     --prompt_file safety_evaluation/data/demo_examples.csv \
#     --prompt_template_style aoa \
#     --output_file safety_evaluation/question_output/demo/exchange_7b.jsonl
# done


for layer in {21..31}; do
   CUDA_VISIBLE_DEVICES=2,3 torchrun --nnodes 1 --nproc_per_node 1 \
    safety_evaluation/exchange_layer_inference.py \
    --bn_model_name ckpts/Llama-2-7b-chat-fp16 \
    --ft_model_name finetuned_models/aoa-7b-full \
    --exchange_layers "$layer" \
    --prompt_file safety_evaluation/data/harmful_behaviors_less.csv \
    --prompt_template_style aoa \
    --output_file safety_evaluation/question_output/harmful_less/exchange_7b.jsonl
done

for layer in {0..29}; do
   CUDA_VISIBLE_DEVICES=2,3 torchrun --nnodes 1 --nproc_per_node 1 \
    safety_evaluation/exchange_layer_inference.py \
    --bn_model_name ckpts/Llama-2-7b-chat-fp16 \
    --ft_model_name finetuned_models/aoa-7b-full \
    --exchange_layers "$layer.$((layer + 1)).$((layer + 2))" \
    --prompt_file safety_evaluation/data/harmful_behaviors_less.csv \
    --prompt_template_style aoa \
    --output_file safety_evaluation/question_output/harmful_less/exchange_7b.jsonl
done