
CUDA_VISIBLE_DEVICES=2,3 torchrun --nnodes 1 --nproc_per_node 2 finetuning_iter.py \
--batch_size_training 128 --lr 5e-5 \
--num_epochs 10 \
--dataset bt_dataset \
--enable_fsdp \
--model_name finetuned_models/aoa-7b-full --pure_bf16 \
--ft_method $method

for i in 0 1 2 3 4 5 6 7 8
do
    python inference/checkpoint_converter_fsdp_hf.py \
    -fsdp_checkpoint_path "fsdp/fine-tuned-finetuned_models/$method-it=$i/aoa-7b-full" \
    -consolidated_model_path "finetuned_models/$dir/lima-aoa-7b-$method-it=$i" \
    -HF_model_path_or_name "finetuned_models/aoa-7b-full"
done

for i in 0 1 2 3 4 5 6 7
do
    CUDA_VISIBLE_DEVICES=3 python -u safety_evaluation/question_inference.py \
    --model_name finetuned_models/$dir/lima-aoa-7b-$method-it=$i \
    --prompt_file safety_evaluation/data/harmful_less.csv \
    --prompt_template_style aoa \
    --output_file safety_evaluation/question_output/harmful_less/7b/lima$dir-aoa-$method-it=$i.jsonl
done
