dir="10000p"
method="sequential"

CUDA_VISIBLE_DEVICES=2,3 torchrun --nnodes 1 --nproc_per_node 2 finetuning_iter.py \
--batch_size_training 128 --lr 5e-5 \
--num_epochs 10 \
--dataset bt_dataset \
--enable_fsdp \
--model_name ckpts/Llama-2-7b-chat-hf --pure_bf16 \
--ft_method $method

for i in 0 1 2 3 4 5 6 7
do
    python inference/checkpoint_converter_fsdp_hf.py \
    -fsdp_checkpoint_path "fsdp/fine-tuned-ckpts/$method-it=$i/Llama-2-7b-chat-hf" \
    -consolidated_model_path "finetuned_models/$dir/lima-7b-$method-it=$i" \
    -HF_model_path_or_name "ckpts/Llama-2-7b-chat-hf"
done

for i in 0 1 2 3 4 5 6 7
do
    CUDA_VISIBLE_DEVICES=2,3 torchrun --nnodes 1 --nproc_per_node 2 finetuning.py \
    --batch_size_training 1 --lr 5e-5 \
    --num_epochs 10 \
    --dataset aoa_dataset \
    --enable_fsdp \
    --model_name finetuned_models/$dir/lima-7b-$method-it=$i --pure_bf16 
done

for i in 0 1 2 3 4 5 6 7
do
    python inference/checkpoint_converter_fsdp_hf.py \
    -fsdp_checkpoint_path "fsdp/fine-tuned-finetuned_models/$dir/lima-7b-$method-it=$i" \
    -consolidated_model_path "finetuned_models/$dir/aoa-lima-7b-$method-it=$i" \
    -HF_model_path_or_name "finetuned_models/$dir/lima-7b-$method-it=$i"
done

# eval
for i in 0 1 2 3 4 5 6 7
do
    CUDA_VISIBLE_DEVICES=3 python -u safety_evaluation/question_inference.py \
    --model_name finetuned_models/$dir/lima-7b-$method-it=$i \
    --prompt_file safety_evaluation/data/harmful_less.csv \
    --prompt_template_style aoa \
    --output_file safety_evaluation/question_output/harmful_less/7b/lima$dir-$method-it=$i.jsonl
done

for i in 0 1 2 3 4 5 6 7
do
    CUDA_VISIBLE_DEVICES=3 python -u safety_evaluation/question_inference.py \
    --model_name finetuned_models/$dir/aoa-lima-7b-$method-it=$i \
    --prompt_file safety_evaluation/data/harmful_less.csv \
    --prompt_template_style aoa \
    --output_file safety_evaluation/question_output/harmful_less/7b/aoa-lima$dir-$method-it=$i.jsonl
done