# repair model

method="sequential"
datadir="safety100"
CUDA_VISIBLE_DEVICES=2,3 torchrun --nnodes 1 --nproc_per_node 2 finetuning_iter.py \
--batch_size_training 2 --lr 5e-5 \
--num_epochs 30 \
--dataset safety_dataset \
--enable_fsdp \
--model_name finetuned_models/aoa-7b-full --pure_bf16 \
--ft_method $method

for i in 6 7
do
    python inference/checkpoint_converter_fsdp_hf.py \
    -fsdp_checkpoint_path "fsdp/fine-tuned-finetuned_models/$method-it=$i/aoa-7b-full" \
    -consolidated_model_path "finetuned_models/$dir/$datadir/lima-aoa-7b-$method-it=$i" \
    -HF_model_path_or_name "finetuned_models/aoa-7b-full"
done


for i in 6 7
do
    CUDA_VISIBLE_DEVICES=2,3 torchrun --nnodes 1 --nproc_per_node 2 finetuning.py \
    --batch_size_training 2 --lr 5e-5 \
    --num_epochs 3 \
    --dataset aoa_dataset \
    --enable_fsdp \
    --model_name finetuned_models/$dir/$datadir/lima-aoa-7b-$method-it=$i --pure_bf16 \
    --save_every_epoch False
done

for i in 6 7
do
    python inference/checkpoint_converter_fsdp_hf.py \
    -fsdp_checkpoint_path "fsdp/fine-tuned-finetuned_models/$dir/$datadir/lima-aoa-7b-$method-it=$i" \
    -consolidated_model_path "finetuned_models/$dir/$datadir/aoa-lima-aoa-7b-$method-it=$i" \
    -HF_model_path_or_name "finetuned_models/aoa-7b-full"
done

## eval

for i in 6 7
do
    CUDA_VISIBLE_DEVICES=3 python -u safety_evaluation/question_inference.py \
    --model_name finetuned_models/$dir/$datadir/lima-aoa-7b-$method-it=$i \
    --prompt_file safety_evaluation/data/harmful_less.csv \
    --prompt_template_style aoa \
    --output_file safety_evaluation/question_output/harmful_less/7b/$datadir/lima$dir-aoa-$method-it=$i.jsonl
done

for i in 6 7
do
    CUDA_VISIBLE_DEVICES=3 python -u safety_evaluation/question_inference.py \
    --model_name finetuned_models/$dir/$datadir/aoa-lima-aoa-7b-$method-it=$i \
    --prompt_file safety_evaluation/data/harmful_less.csv \
    --prompt_template_style aoa \
    --output_file safety_evaluation/question_output/harmful_less/7b/$datadir/aoa-lima$dir-aoa-$method-it=$i.jsonl
done


#--------------------------------------------------------
# normal behaviors

# CUDA_VISIBLE_DEVICES=3 python -u safety_evaluation/question_inference.py \
# --model_name ckpts/Llama-2-7b-chat-hf \
# --prompt_file safety_evaluation/data/normal_behaviors.csv \
# --prompt_template_style aoa \
# --output_file safety_evaluation/question_output/normal/7b/Llama-2-7b-chat-hf.jsonl

# CUDA_VISIBLE_DEVICES=3 python -u safety_evaluation/question_inference.py \
# --model_name finetuned_models/aoa-7b-full \
# --prompt_file safety_evaluation/data/normal_behaviors.csv \
# --prompt_template_style aoa \
# --output_file safety_evaluation/question_output/normal/7b/aoa-7b-full.jsonl

# for j in 10 100
# do
#     for i in 5 10 15 20 25 30
#     do
#         CUDA_VISIBLE_DEVICES=3 python -u safety_evaluation/question_inference.py \
#         --model_name finetuned_models/safety10-aoa-7b-epoch=$i \
#         --prompt_file safety_evaluation/data/normal_behaviors.csv \
#         --prompt_template_style aoa \
#         --output_file safety_evaluation/question_output/normal/7b/safety$j-aoa-epoch=$i.jsonl
#     done
# done