# script for fine-tune model using regmixression data 


for gen_model in "Llama-2-7b-chat-hf" # "Llama-2-7b-chat-fp16" 
do
    for model_name in "chatglm3-6b" # "Meta-Llama-3-8B"  
    do
        for data_name in "alpaca_dataset" "bt_dataset" "dolly_dataset" 
        do
            # CUDA_VISIBLE_DEVICES=1,2,3 torchrun --nproc_per_node 3 ../finetuning.py \
            # --batch_size_training 2 --lr 5e-5 \
            # --num_epochs 5 \
            # --dataset regmix_dataset \
            # --data_path ../../clean_label/small_ppl_dataset/$gen_model/$data_name/0.jsonl \
            # --enable_fsdp \
            # --baseline True \
            # --model_name ../../hf/$model_name --pure_bf16 \
            # --fsdp_checkpoint_path ../fsdp/$model_name/regmix-epoch=5_small_ppl_10k/$gen_model-$data_name/baseline

            python ../inference/checkpoint_converter_fsdp_hf.py \
            -fsdp_checkpoint_path ../fsdp/$model_name/regmix-epoch=5_small_ppl_10k/$gen_model-$data_name/baseline \
            -consolidated_model_path ../finetuned_models/$model_name/regmix-epoch=5_small_ppl_10k/$gen_model-$data_name/baseline \
            -HF_model_path_or_name ../../hf/$model_name

            for iter in 0 
            do
                # CUDA_VISIBLE_DEVICES=1,2,3 torchrun --nproc_per_node 3 ../finetuning.py \
                # --batch_size_training 2 --lr 5e-5 \
                # --num_epochs 5 \
                # --dataset regmix_dataset \
                # --data_path ../../clean_label/small_ppl_dataset/$gen_model/$data_name/$iter.jsonl \
                # --enable_fsdp \
                # --model_name ../../hf/$model_name --pure_bf16 \
                # --fsdp_checkpoint_path ../fsdp/$model_name/regmix-epoch=5_small_ppl_10k/$gen_model-$data_name/$iter

                python ../inference/checkpoint_converter_fsdp_hf.py \
                -fsdp_checkpoint_path ../fsdp/$model_name/regmix-epoch=5_small_ppl_10k/$gen_model-$data_name/$iter \
                -consolidated_model_path ../finetuned_models/$model_name/regmix-epoch=5_small_ppl_10k/$gen_model-$data_name/$iter \
                -HF_model_path_or_name ../../hf/$model_name
            done
        done
    done
done


