import torch
from transformers import GPT2Tokenizer, GPT2Model
import numpy as np

# Load pre-trained GPT-2 tokenizer and model
tokenizer = GPT2Tokenizer.from_pretrained("gpt2")
model = GPT2Model.from_pretrained("gpt2")
model.eval()

# Preprocess input text
input_text = "I really love to pursue Ph.D. degree"
words = input_text.split()

# Example: Using pre-trained GloVe embeddings
word_embeddings = {}  # Example: dictionary containing GloVe embeddings for words
word_embedding_dim = 768  # Example: GloVe embedding dimension

input_embeddings = []
for word in words:
    if word in word_embeddings:
        input_embeddings.append(word_embeddings[word])
    else:
        input_embeddings.append(np.random.randn(word_embedding_dim))  # Random embedding for unknown words

input_embedding_tensor = torch.tensor(input_embeddings)  # Convert to tensor

# Pass input embeddings to the model
with torch.no_grad():
    outputs = model(inputs_embeds=input_embedding_tensor.unsqueeze(0))  # Add batch dimension
    last_hidden_states = outputs.last_hidden_state

print(outputs)
# Use last_hidden_states for further processing or downstream tasks
