#ifndef SPECTRUM_CANDIDATERULES_H
#define SPECTRUM_CANDIDATERULES_H

#include "../Fragments/Fragments.h"
#include "../Utils/profiling_utils.h"
#include <sstream>
#include <iomanip>

using PredicateId = std::size_t ;
using Fragment = vector<PredicateId>;

struct Rule{
    Fragment head;
    Fragment body;
    Fragment rule; //Reordered to HEAD<-BODY
    vector<Location> locations;
    unordered_map<NodeId, size_t> covered_locations_count; // The nodes that it predicts (i.e. different heads)
    unordered_set<NodeId> covered_locations; // The maximum number of nodes the rule could have predicted
    double utility;
    double fidelity;
    unordered_map<EdgeId, double> local_structure_penalty;
};


class CandidateRuleCollection{
private:
    FragmentCollection fragment_collection;
    unordered_map<PredicateId, vector<Rule>> candidate_rules; // KEY Rule in Head <- Body shape
    HyperGraph hg;
    unordered_map<PredicateId, Predicate> predicate_id_to_name;
    unordered_map<Predicate, PredicateId> predicate_name_to_id;
    unordered_map<EdgeId, vector<NodeId>> relations;

public:
    CandidateRuleCollection(FragmentCollection fragment_collection, double min_fidelity, const vector<string>& target_predicates);
    vector<Fragment> get_constrained_fragments(const unordered_set<PredicateId>& target_predicates);
    vector<Fragment> get_constrained_cyclic_fragments();
    void calculate_coverage();
    vector<Rule> get_final_rules(size_t max_number_of_rules, const vector<string>& target_predicates);
    static pair<double,size_t>  calculate_utility(const vector<Rule>& rules);
    static double calculate_complexity(const vector<Rule>& rules);
    void print_rules(const string& logic,
                     const string& output_file_name,
                     size_t max_number_of_rules,
                     const vector<string>& target_predicates);
    string print_rule(Rule rule, const string& logic);
    void calculate_structure_penalties();
    static double compute_local_utility(EdgeId head, vector<Rule> rules);
};
std::string doubleToStringWithTwoDecimals(double value);
#endif //SPECTRUM_CANDIDATERULES_H
