#ifndef SPECTRUM_FRAGMENTS_H
#define SPECTRUM_FRAGMENTS_H

#include <iostream>
#include <map>
#include <vector>
#include <set>
#include <unordered_set>
#include <string>
#include <cctype>
#include <list>
#include <algorithm>
#include <random>
#include "../HyperGraphs/HyperGraph.h"
#include "fragment_utils.h"
#include "../Utils/vector_utils.h"
#include <omp.h>

using namespace std;
using NodeId = size_t;
using NodeName = string;
using EdgeId = size_t;
using PredicateId = size_t;
using Predicate = string;
using Location = vector<EdgeId>;
using Fragment = vector<PredicateId>;

class FragmentCollection{
private:
    map<Fragment, vector<Location>> fragment_count;
    map<Fragment, vector<Location>> fragment_cyclic_count;
    unordered_map<NodeId, pair<vector<EdgeId>,vector<EdgeId>>> unary_binary_edges;
    unordered_map<EdgeId, PredicateId> edge_to_predicate;
    unordered_set<PredicateId> unary_predicates;

public:
    HyperGraph hg;
    FragmentCollection(const HyperGraph& hg, size_t number_of_random_walks, size_t max_depth, bool force_cyclic);
    FragmentCollection();
    void set_initial_fragments(NodeId node, vector<EdgeId> unaries, const vector<EdgeId>& binaries);
    void storing_fragments(const map<Fragment, Location>& fragments);
    void storing_cyclic_fragments(const map<Fragment, Location>& fragments);
    void get_fragments(size_t number_of_random_walks, size_t max_depth, bool force_cyclic);
    map<Fragment, vector<Location>> get_fragment_count();
    map<Fragment, vector<Location>> get_fragment_cyclic_count();
    void set_fragment_count(map<Fragment, vector<Location>> fragment_count);
    void set_fragment_cyclic_count(map<Fragment, vector<Location>> fragment_cyclic_count);
    string get_predicate_from_id(PredicateId predicate);
    PredicateId get_predicate_id(Predicate predicate);
    void next_step(size_t number_of_random_walks,
                   NodeId node,
                   NodeId starting_node,
                   int depth,
                   const map<vector<PredicateId>, Location> &fragments,
                   unordered_set<EdgeId> previous_edges,
                   size_t max_depth,
                   bool force_cyclic);
    bool is_unary(PredicateId predicate);
    bool is_unary_edge(EdgeId edge);
    vector<NodeId> get_edge(EdgeId edge);
    pair<vector<EdgeId>,vector<EdgeId>> get_unary_binary_edges(NodeId node);
};
#endif //SPECTRUM_FRAGMENTS_H
