# Running experiments
## Requirements:
* Python 3.6 or higher;
* Nvidia T4 GPU or equivalent;
* TensorFlow 1.15 (see `requirements.txt`).

## Training & Evaluation
* set training directory `train_dir` in `config.py` file;
* set data directory `data_dir` in `config.py` file;
* select task by uncommenting task section in `config.py` file.
Matrix transpose task is selected by default.
* Sudoku data should be manually downloaded from [GitHub](https://github.com/Kyubyong/sudoku)
and extracted in `data_dir/sudoku` (optional);

* then run `python3 trainer.py --train --eval`. Checkpoints will be saved in `train_dir`;
* for algorithmic tasks, datasets will be generated in `data_dir` on the first run, sequential runs
will reuse this dataset;
* to evaluated generalization on larger inputs add `--gen_test` when starting training. Generalization results will be available in `train_dir/gen_test.txt`;
* you can restart training or evaluation from the previous checkpoint using `--continue <checkpoint_dir>` flag.
* model can be tested on whole test dataset using `--test` flag

## Task selection

### Matrix squaring (Squaring):
Given a binary matrix, the model is required to output its square (matrix multiplication with itself) modulo 2.
Data generation for this task is given in the `data/matrix.py` file.

To choose this task, in `config.py` uncomment:
```
""" Recommended settings for Matrix Squaring task """
model = MatrixSE(feature_maps=96, block_count=2)
dataset = Squaring()
```

### Matrix transpose (Transpose):
Given a matrix with elements of alphabet 1-11, the model is required to output its transposed matrix.
Data generation for this task is given in the `data/matrix.py` file.

To choose this task, in `config.py` uncomment:
```
""" Recommended settings for Matrix Transpose task """
model = MatrixSE(feature_maps=96, block_count=2)
dataset = Transpose()
```
### Matrix Rotation by 90 degrees (Rotate90):
Given a matrix with elements of alphabet 1-11, the model is required to output matrix that has been rotated by 90 degrees clockwise.
Data generation for this task is given in the `data/matrix.py` file.

To choose this task, in `config.py` uncomment:
```
""" Recommended settings for Matrix Rotate by 90 degrees task """
# model = MatrixSE(feature_maps=96, block_count=2)
# dataset = Rotate90()
```

### Element-wise XOR operation of two matrices (BitwiseXOR):
Given two binary matrices, the model is required to output a matrix that has been obtained by element-wise XOR operation.
Data generation for this task is given in `data/matrices.py` file.

To chose this task, in `config.py` uncomment:
```
""" Recommended settings for bitwise XOR of matrices """
# model = MatrixSE(feature_maps=96, block_count=2)
# dataset = BitwiseXOR()
```

### Connected Component Labeling (ComponentLabeling):
We initialize a labeled graph with random edge labels in range 2-100. 
The task is to label all edges of each connected component with the lowest label among all the component’s edges.
Data generation for this task is given in `data/graph.py` file.

To choose this task, in `config.py` uncomment:
```
""" Recommended settings for Component Labeling in the graph """
# model = MatrixSE(feature_maps=192, block_count=2)
# dataset = ComponentLabeling()
```

### Triangle Finding in a graph (TriangleFinding):
We generate random complete bipartite graphs and add a few random edges.
The goal is to return all the edges belonging to any triangle.
Data generation for this task is given in the `data/graph.py` file.

To choose this task, in `config.py` uncomment:
```
""" Recommended settings for Triangle Finding in graph """
# model = MatrixSE(feature_maps=192, block_count=2)
# dataset = TriangleFinding()
# adjust_class_imbalance = True
```

### Transitive path finding in a graph (Transitivity):
Given a directed graph, the goal is to add edges to a graph for every two vertices
that have a transitive path of length 2 between them.
Data generation for this task is given in the `data/graph.py` file.

To choose this task, in `config.py` uncomment:
```
""" Recommended settings for Transitive Path in the graph """
model = MatrixSE(feature_maps=192, block_count=2)
dataset = Transitivity()
adjust_class_imbalance = True
```

### Sudoku puzzle solving (Sudoku)
Given the empty Sudoku puzzle, the model is required to give a solution in one step.
Data preparation for this task is given in the `data/sudoku.py` file.

To choose this task, in `config.py` uncomment:
```
""" Recommended settings for Sudoku puzzle solving """
model = MatrixSEMultistep(feature_maps=96, block_count=2, train_steps=10, eval_steps=30)
dataset = Sudoku()
train_steps = 1000000
```

### Sudoku puzzle solving (SudokuHard)
Given the empty Sudoku puzzle, the model is required to give a solution in one step.
Data preparation for this task is given in the `data/sudoku.py` file.

To choose this task, in `config.py` uncomment:
```
""" Recommended settings for Sudoku puzzle solving """
model = MatrixSEMultistep(feature_maps=96, block_count=2, train_steps=10, eval_steps=30)
dataset = SudokuHard()
train_steps = 1000000
```