
  
# Reverse Engineering Self-Supervised Learning   
There are several components in this module.   
## Requirements: 

 1. pytorch
 2. pytorch-lightning
 3. lightly
 4. scikit-learn
 5. joblib
 6. tqdm
 7. urllib3
 8. yaml
 9. argparse
 10. glob

## Training SSL algorithm on CIFAR100   

VICReg, with ConvRes-5-250 as default.   
 command:  
    `python self_supervised_train/ssl_train.py --task ssl_train`  
**outputs:**  

 - `<output_folder>/ssl_train/`  
	 - `checkpoints`   
 - `version_0`  (tb logs)
 - `hparams.yaml`  
 - `metrics.csv`  

## Training Supervised Classification on CIFAR100  
`python offline_evaluation/run_offline_eval.py --task train_supervised_classifier --checkpoint_folder --output_folder <output_folder> `  
  
  
## Get classifier predictions  
`python offline_evaluation/run_offline_eval.py --task get_classifier_predictions --checkpoint_folder <checkpoint_folder>`  

## Linear offline eval 
`python offline_evaluation/run_offline_eval.py --task linear --checkpoint_folder <ssl_checkpoint_folder> --rand_targets_folder <random_targets_prediction_folder>`  
  
    
## NCC offline eval 
`python offline_evaluation/run_offline_eval.py --task ncc --checkpoint_folder <ssl_checkpoint_folder> --rand_targets_folder <random_targets_prediction_folder>`  
  