# bias-in-facial-recognition
Code repository for the paper "Comparing Human and Machine Bias in Face Recognition"

Please cite using bibtex:
```
@inproceedings{anonymous2022comparing,
    title={Comparing Human and Machine Bias in Face Recognition},
    author={Anonymous},
    booktitle={Submitted to The Tenth International Conference on Learning Representations },
    year={2022},
    url={https://openreview.net/forum?id=NsyO8nGpaGG},
    note={under review}
}
```

## InterRec Dataset

The InterRec DataSet contains 7447 images across 2545 unique identities. The dataset is comprised of images from both
Labeled Faces in the Wild (LFW) and Celebrity A dataset (CelebA). In order to create the InterRec dataset, you must
select the images from the InterRec metadata files (provided in `InterRec/`). The `create_interrec.py` script will
automate this process for you following the instructions below

### Instructions

0. Prerequisites

    a. python 3.8+

    b. Python packages: numpy, pandas

    c. Kaggle command line tools

    d. Set Kaggle environment variables: `export KAGGLE_USERNAME=YOUR_USERNAME` and `export KAGGLE_KEY=XXXXXXXXX`

1. Run the script: `python -m create_interrec --interrec interrec/`

_If you have either the LFW or CelebA dataset downloaded already, you can save a lot of time by providing those paths
in the script's arguments_
(i.e. `python -m create_facerace --interrec interrec/ --lfw path/to/lfw --celeba path/to/celeba`)

## Analysis

Code for the analysis sections of the paper can be found in `data_analysis/` (includes process for analyzing survey
responses and comparing to machine models) and `commercial_model_data_collection/` (includes analysis for evaluating
commercial models)

## Errata

No errata exist as of October 5th, 2021
