# Academic Machine Bias
* Code used to train ResNet-18, ResNet-50, and MobileFaceNet backbones
with the ArcFace and CosFace heads on <!-- TODO: Valeriia, please describe the train dataset here -->.
* Developed code to run facial identification and verification tasks
used in the human survey on the FaceRace dataset.

|Author|Homepage|
|:---:|:---:|
|Jian Zhao|https://zhaoj9014.github.io|

****
## License

This code is based off of [face.evoLVe](https://github.com/ZhaoJ9014/face.evoLVe), 
which is released under the MIT License.
  
****
## Contents
* [Introduction](#Introduction)
* [Prerequisites](#Prerequisites)
* [Face Alignment](#Face-Alignment)
* [Training and Validation](#Training-and-Validation)
* [Prediction](#Prediction)
* [References](#References)

****
## face.evoLVe for High-Performance Face Recognition

### Introduction 

<img src="https://github.com/ZhaoJ9014/face.evoLVe/blob/master/disp/Fig1.png" width="450px"/>  <img src="https://github.com/ZhaoJ9014/face.evoLVe/blob/master/disp/Fig17.png" width="400px"/>

Please visit [face.evoLVe](https://github.com/ZhaoJ9014/face.evoLVe) for
a full overview of the functionality/features in this part of the repo.

****
### Prerequisites 

* Linux or macOS
* [Python 3.7](https://repo.continuum.io/archive/Anaconda3-2018.12-Linux-x86_64.sh) (for training \& validation)
* bcolz (refer to [face.evoLVe](https://github.com/ZhaoJ9014/face.evoLVe))
* Comet-ML (for logging training loss \& validation metrics)
* NumPy (vectorized operations)
* OpenCV (refer to [face.evoLVe](https://github.com/ZhaoJ9014/face.evoLVe))
* Pandas (for reading CSVs)
* Pillow (for reading in images in PyTorch `Dataset`s)
* PyTorch (for training \& validation, both `torch` and `torchvision`)
* tqdm (for progess bar)

### Face Alignment 
<img src="https://github.com/ZhaoJ9014/face.evoLVe/blob/master/disp/Fig2.png" width="900px"/>
<img src="https://github.com/ZhaoJ9014/face.evoLVe/blob/master/disp/Fig3.png" width="500px"/>

* Folder: `./align`
* Face alignment API as provided in [face.evoLVe](https://github.com/ZhaoJ9014/face.evoLVe). Make sure to run

  ```commandline
  python3 util/nest.py -s [source_dir] -o [output_dir]
  ```

  so that the command below runs properly.


  ```
  python face_align.py -source_root [source_root] -dest_root [dest_root] -crop_size [crop_size]

  # python face_align.py -source_root images/ -dest_root aligned-crop_size 112
  ```

****
### Training and Validation 

* Folder: `./`
* See [face.evoLVe](https://github.com/ZhaoJ9014/face.evoLVe) for details.

****
### Predictions

* Folder: `./`
* Make sure that the images are [aligned](#Face-Alignment) first and that
  they are stored in `./aligned`. Also, make sure to run

  ```commandline
  $ mv aligned/*/* aligned
  ````

  to unnest the aligned images. Finally, put `identification_questions.csv`
  and `verification_questions.csv` into `./csvs` before running

  ```commandline
  $ python3 test.py
  ```

* Both Cosine-similarity and L2 distance was analyzed to make the 
  predictions. They both seemed to produce the same predictions.

****
### References 

- Please consult the following papers for reference:

      @article{wang2021face,
        title={Face. evoLVe: A High-Performance Face Recognition Library},
        author={Wang, Qingzhong and Zhang, Pengfei and Xiong, Haoyi and Zhao, Jian},
        journal={arXiv preprint arXiv:2107.08621},
        year={2021}
      }
      
      
      @article{tu2021image,
        title={Image-to-Video Generation via 3D Facial Dynamics},
        author={Tu, Xiaoguang and Zou, Yingtian and Zhao, Jian and Ai, Wenjie and Dong, Jian and Yao, Yuan and Wang, Zhikang and Guo, Guodong and Li, Zhifeng and Liu, Wei and others},
        journal={T-CSVT},
        year={2021}
      }
      
      
      @article{tu2021joint,
        title={Joint Face Image Restoration and Frontalization for Recognition},
        author={Tu, Xiaoguang and Zhao, Jian and Liu, Qiankun and Ai, Wenjie and Guo, Guodong and Li, Zhifeng and Liu, Wei and Feng, Jiashi},
        journal={T-CSVT},
        year={2021}
      }


      @article{zhao2020towards,
        title={Towards age-invariant face recognition},
        author={Zhao, Jian and Yan, Shuicheng and Feng, Jiashi},
        journal={T-PAMI},
        year={2020}
      }


      @article{liang2020fine,
        title={Fine-grained facial expression recognition in the wild},
        author={Liang, Liqian and Lang, Congyan and Li, Yidong and Feng, Songhe and Zhao, Jian},
        journal={T-IFS},
        pages={482--494},
        year={2020}
      }


      @article{tu2020learning,
        title={Learning generalizable and identity-discriminative representations for face anti-spoofing},
        author={Tu, Xiaoguang and Ma, Zheng and Zhao, Jian and Du, Guodong and Xie, Mei and Feng, Jiashi},
        journal={T-IST},
        pages={1--19},
        year={2020}
      }


      @article{tu20203d,
        title={3D face reconstruction from a single image assisted by 2D face images in the wild},
        author={Tu, Xiaoguang and Zhao, Jian and Xie, Mei and Jiang, Zihang and Balamurugan, Akshaya and Luo, Yao and Zhao, Yang and He, Lingxiao and Ma, Zheng and Feng, Jiashi},
        journal={T-MM},
        year={2020}
      }


      @inproceedings{wang2020learning,
        title={Learning to Detect Head Movement in Unconstrained Remote Gaze Estimation in the Wild},
        author={Wang, Zhecan and Zhao, Jian and Lu, Cheng and Yang, Fan and Huang, Han and Guo, Yandong and others},
        booktitle={WACV},
        pages={3443--3452},
        year={2020}
      }


      @article{zhao2019recognizing,
        title={Recognizing Profile Faces by Imagining Frontal View},
        author={Zhao, Jian and Xing, Junliang and Xiong, Lin and Yan, Shuicheng and Feng, Jiashi},
        journal={IJCV},
        pages={1--19},
        year={2019}
      }


      @article{kong2019cross,
        title={Cross-Resolution Face Recognition via Prior-Aided Face Hallucination and Residual Knowledge Distillation},
        author={Kong, Hanyang and Zhao, Jian and Tu, Xiaoguang and Xing, Junliang and Shen, Shengmei and Feng, Jiashi},
        journal={arXiv preprint arXiv:1905.10777},
        year={2019}
      }


      @article{tu2019joint,
        title={Joint 3D face reconstruction and dense face alignment from a single image with 2D-assisted self-supervised learning},
        author={Tu, Xiaoguang and Zhao, Jian and Jiang, Zihang and Luo, Yao and Xie, Mei and Zhao, Yang and He, Linxiao and Ma, Zheng and Feng, Jiashi},
        journal={arXiv preprint arXiv:1903.09359},
        year={2019}
      }     


      @inproceedings{zhao2019multi,
        title={Multi-Prototype Networks for Unconstrained Set-based Face Recognition},
        author={Zhao, Jian and Li, Jianshu and Tu, Xiaoguang and Zhao, Fang and Xin, Yuan and Xing, Junliang and Liu, Hengzhu and Yan, Shuicheng and Feng, Jiashi},
        booktitle={IJCAI},
        year={2019}
      }


      @inproceedings{zhao2019look,
        title={Look Across Elapse: Disentangled Representation Learning and Photorealistic Cross-Age Face Synthesis for Age-Invariant Face Recognition},
        author={Zhao, Jian and Cheng, Yu and Cheng, Yi and Yang, Yang and Lan, Haochong and Zhao, Fang and Xiong, Lin and Xu, Yan and Li, Jianshu and Pranata, Sugiri and others},
        booktitle={AAAI},
        year={2019}
      }
      
      
      @article{tu2019joint,
        title={Joint 3D Face Reconstruction and Dense Face Alignment from A Single Image with 2D-Assisted Self-Supervised Learning},
        author={Tu, Xiaoguang and Zhao, Jian and Jiang, Zihang and Luo, Yao and Xie, Mei and Zhao, Yang and He, Linxiao and Ma, Zheng and Feng, Jiashi},
        journal={arXiv preprint arXiv:1903.09359},
        year={2019}
      }
      
      
      @article{tu2019learning,
        title={Learning Generalizable and Identity-Discriminative Representations for Face Anti-Spoofing},
        author={Tu, Xiaoguang and Zhao, Jian and Xie, Mei and Du, Guodong and Zhang, Hengsheng and Li, Jianshu and Ma, Zheng and Feng, Jiashi},
        journal={arXiv preprint arXiv:1901.05602},
        year={2019}
      }
      
      
      @article{zhao20183d,
        title={3D-Aided Dual-Agent GANs for Unconstrained Face Recognition},
        author={Zhao, Jian and Xiong, Lin and Li, Jianshu and Xing, Junliang and Yan, Shuicheng and Feng, Jiashi},
        journal={T-PAMI},
        year={2018}
      }
      
      
      @inproceedings{zhao2018towards,
        title={Towards Pose Invariant Face Recognition in the Wild},
        author={Zhao, Jian and Cheng, Yu and Xu, Yan and Xiong, Lin and Li, Jianshu and Zhao, Fang and Jayashree, Karlekar and Pranata,         Sugiri and Shen, Shengmei and Xing, Junliang and others},
        booktitle={CVPR},
        pages={2207--2216},
        year={2018}
      }
      
      
      @inproceedings{zhao3d,
        title={3D-Aided Deep Pose-Invariant Face Recognition},
        author={Zhao, Jian and Xiong, Lin and Cheng, Yu and Cheng, Yi and Li, Jianshu and Zhou, Li and Xu, Yan and Karlekar, Jayashree and       Pranata, Sugiri and Shen, Shengmei and others},
        booktitle={IJCAI},
        pages={1184--1190},
        year={2018}
      }
      
      
      @inproceedings{zhao2018dynamic,
        title={Dynamic Conditional Networks for Few-Shot Learning},
        author={Zhao, Fang and Zhao, Jian and Yan, Shuicheng and Feng, Jiashi},
        booktitle={ECCV},
        pages={19--35},
        year={2018}
      }
      
      
      @inproceedings{zhao2017dual,
        title={Dual-agent gans for photorealistic and identity preserving profile face synthesis},
        author={Zhao, Jian and Xiong, Lin and Jayashree, Panasonic Karlekar and Li, Jianshu and Zhao, Fang and Wang, Zhecan and Pranata,           Panasonic Sugiri and Shen, Panasonic Shengmei and Yan, Shuicheng and Feng, Jiashi},
        booktitle={NeurIPS},
        pages={66--76},
        year={2017}
      }
      
      
      @inproceedings{zhao122017marginalized,
        title={Marginalized cnn: Learning deep invariant representations},
        author={Zhao12, Jian and Li, Jianshu and Zhao, Fang and Yan13, Shuicheng and Feng, Jiashi},
        booktitle={BMVC},
        year={2017}
      }
      
      
      @inproceedings{cheng2017know,
        title={Know you at one glance: A compact vector representation for low-shot learning},
        author={Cheng, Yu and Zhao, Jian and Wang, Zhecan and Xu, Yan and Jayashree, Karlekar and Shen, Shengmei and Feng, Jiashi},
        booktitle={ICCVW},
        pages={1924--1932},
        year={2017}
      }
      
      
      @inproceedings{xu2017high,
        title={High performance large scale face recognition with multi-cognition softmax and feature retrieval},
        author={Xu, Yan and Cheng, Yu and Zhao, Jian and Wang, Zhecan and Xiong, Lin and Jayashree, Karlekar and Tamura, Hajime and Kagaya, Tomoyuki and Shen, Shengmei and Pranata, Sugiri and others},
        booktitle={ICCVW},
        pages={1898--1906},
        year={2017}
      }
      
      
      @inproceedings{wangconditional,
        title={Conditional Dual-Agent GANs for Photorealistic and Annotation Preserving Image Synthesis},
        author={Wang, Zhecan and Zhao, Jian and Cheng, Yu and Xiao, Shengtao and Li, Jianshu and Zhao, Fang and Feng, Jiashi and Kassim, Ashraf},
        booktitle={BMVCW},
      }
      
      
      @inproceedings{li2017integrated,
        title={Integrated face analytics networks through cross-dataset hybrid training},
        author={Li, Jianshu and Xiao, Shengtao and Zhao, Fang and Zhao, Jian and Li, Jianan and Feng, Jiashi and Yan, Shuicheng and Sim, Terence},
        booktitle={ACM MM},
        pages={1531--1539},
        year={2017}
      }
      
      
      @article{xiong2017good,
        title={A good practice towards top performance of face recognition: Transferred deep feature fusion},
        author={Xiong, Lin and Karlekar, Jayashree and Zhao, Jian and Cheng, Yi and Xu, Yan and Feng, Jiashi and Pranata, Sugiri and Shen, Shengmei},
        journal={arXiv preprint arXiv:1704.00438},
        year={2017}
      }
      
      
      @article{zhao2017robust,
        title={Robust lstm-autoencoders for face de-occlusion in the wild},
        author={Zhao, Fang and Feng, Jiashi and Zhao, Jian and Yang, Wenhan and Yan, Shuicheng},
        journal={T-IP},
        volume={27},
        number={2},
        pages={778--790},
        year={2017}
      }
 
 
      @inproceedings{li2016robust,
        title={Robust face recognition with deep multi-view representation learning},
        author={Li, Jianshu and Zhao, Jian and Zhao, Fang and Liu, Hao and Li, Jing and Shen, Shengmei and Feng, Jiashi and Sim, Terence},
        booktitle={ACM MM},
        pages={1068--1072},
        year={2016}
      }
