import subprocess
import pandas as pd
import numpy as np


ver_questions = pd.read_csv("verification_questions.csv")

ver = []

api_key = "HERE"
api_secret = "THERE"


for index, row in ver_questions.iterrows():
    output = subprocess.check_output(["curl", '-X', 'POST', "https://api-us.faceplusplus.com/facepp/v3/compare",
                                  '-F', "api_key={}".format(api_key),
                                  '-F', "api_secret={}".format(api_secret),
                                  '-F', "image_url1=https://inthewild.s3.us-east-2.amazonaws.com/reu_project/verification/{}".format(row.target_image),
                                  '-F', "image_url2=https://inthewild.s3.us-east-2.amazonaws.com/reu_project/verification/{}".format(row.other_image)])
    ver += [output]




ver = [json.loads(x) for x in ver]
df = pd.json_normalize(ver, sep='_')
df = df.join(ver_questions)
df['answered_correctly'] = (df['thresholds_1e-4'] < df.confidence) == df.positive
df.to_csv("megvii_verification_answers.csv",index=False)
