#!/bin/bash

# Check if an argument is provided
if [ $# -eq 0 ]; then
    echo "Usage: $0 <number_of_iterations>"
    exit 1
fi

# Number of iterations passed as an argument
NUM_ITERATIONS=$1

# Define the initial values for model_name_or_path and hub_model_id
initial_model_name_or_path= # Input supervised fine-tuning model, e.g., "<HuggingFace User>/phi-2-sft"
model_name_or_path_prefix= # Input prefix of aligned models, e.g., "<HuggingFace User>/phi-2-irepo-i"
hub_model_id_prefix= # Input prefix of aligned models to push to hub, e.g., "<HuggingFace User>/phi-2-irepo-i"

# Loop through a predefined set of iterations
for ((i=0; i<NUM_ITERATIONS; i++)); do
  # Calculate the next iteration values
  next_i=$((i + 1))
  pre_i=$((i - 1))

  # Set the current model name and hub model id
  if [[ $i -eq 0 ]]; then
    model_name_or_path="$initial_model_name_or_path"
    hub_model_id="${hub_model_id_prefix}${i}"
    output_dir= "${hub_model_id_prefix}${i}-local"
  else
    model_name_or_path="${hub_model_id_prefix}${pre_i}"
    hub_model_id="${hub_model_id_prefix}${i}"
    output_dir= "${hub_model_id_prefix}${i}-local"
  fi

  echo "i: $i"
  echo "model_name_or_path: $model_name_or_path"
  echo "hub_model_id: $hub_model_id"
  echo "output_dir: $hub_model_id"

  # Run the command
  ACCELERATE_LOG_LEVEL=info accelerate launch --config_file recipes/accelerate_configs/deepspeed_zero3.yaml scripts/run_irepo.py recipes/phi-2/irepo/config_sample_lora.yaml --load_in_4bit=false --model_name_or_path="$model_name_or_path" --hub_model_id="$hub_model_id" --output_dir="$output_dir" 


  # Sleep for 1 minute
  sleep 1m
done
