# On the Relationship Between Heterophily and Robustness of Graph Neural Networks

This repository is the anonymized implementation of the paper *On the Relationship Between Heterophily and Robustness of Graph Neural Networks*, and is for review only. **Do NOT distribute**. We will publish the codebase upon acceptance and publication of the paper.

## Requirements
1. Install a conda virtual environment with requirements

    ```
    conda env create -f HeteroRobustEnv.yml
    ```
2. Activate the new environment `conda activate torch`. The virtual environment is named as `torch`, and you can change it manually by modifying the first line of `HeteroRobustEnv.yml`.

    ```
    conda activate torch
    ```

3. Verify that the new environment was installed correctly:

    ```
    (torch) conda env list
    ```
    
    Should you meet any problem, refer to the [official conda document](https://conda.io/projects/conda/en/latest/user-guide/tasks/manage-environments.html#creating-an-environment-from-an-environment-yml-file).

4. Additionally, you will need to manually install TensorFlow==2.2 to run H2GCN, CPGNN and GraphSAGE , and make sure that you are running all the code with a CUDA-enabled GPU.

## Attack Generation
* To generate attacks with Nettack, run the executable file in `./bin/nettack-adj-only.sh`:

    ```
    (torch) chmod +x ./bin/nettack-adj-only.sh
    (torch) ./bin/nettack-adj-only.sh
    ```
    You can modify the configurations in `./bin/nettack-adj-only.sh`.
    * Change the random seed `SEED`
    * Change the `DATASET` you want to attack from `[cora, citeseer, fb100, snap-patents-downsampled]`
    * Change the number of target nodes `--random_num <Number_OF_TARGET_NODES>`
* To generate attacks with Metattack, run this command:

    ```
    (torch) chmod +x ./bin/metattack-adj-only.sh
    (torch) ./bin/metattack-adj-only.sh
    ```
    You can modify the configurations in `./bin/metattack-adj-only.sh`.
    * Change the random seed `SEED`
    * Change the `DATASET` you want to attack from `[cora, citeseer, fb100, snap-patents-downsampled]`
    * Change the percentage of the edges to be perturbed `ptb_ratio`. Please enter `ptb_ratio` as a float between [0, 1].


## Evaluation

To perform robustness evaluation of the GNN models: 
1. Modify the `config` files in `./configs/` folder. 
    
    For Nettack and Metattack, 
    * You will need to first generate the perturbations as instructed in last section;
    * Please make sure `PerturbJobFilters/doc/comment` meet with your `EXP_NAME` in the attack phase (`/bin/nettack-adj-only.sh`  or  `./bin/metattack-adj-only.sh`);
    * Refer to the table below for the detailed arguments for each GNN model;
    * For each model, you can switch between poison attack only `poison`, evasion attack only `evasion`, and both poison attack and evasion attack `poison+evasion`;
    * Tunable hyperparameters are listed in `Vars`;
    * For Nettack, modify `./configs/iclr21-adj-only-nettack/nettack-adj-only.json`;
    * For Metattack, modify `./configs/iclr21-adj-only-metattack/metattack-adj-only.json`.

    For Certifiable robustness, 
    * You do not need to generate perturbations first;
    * Sparse smoothing parameters are listed in `SessionConfig` and `TemplateVars`;
    * Datasets used are listed in `datasetName`;
    * Modify `./configs/iclr21-adj-only-cert/sparse-smoothing-cert.json`.
    

2. Run the evaluation
    ```eval
    python -m HeteroRobust.runner configs/<CONFIG_TO_RUN> -p <NUMBER_OF_WORKERS>
    ```
    For example, to evaluate with Nettack with 4 workers, run the following code.
    ```
    python -m HeteroRobust.runner configs/iclr21-adj-only-nettack/nettack-adj-only.json -p 4
    ```
    To evaluate the certifiable robustness with 4 workers, run the following code.
    ```
    python -m HeteroRobust.runner configs/iclr21-adj-only-cert/sparse-smoothing-cert.json -p 4
    ```

3. The outputs will be stored in the `workspace` folder. And you can analyze the results using the jupyter notebooks provided in the `results` folder. Refer to the Results section for more details.


Below are the model arguments used in experiments of the paper.

| GNN       | model_name | argument           |
|-----------|------------|--------------------|
| H2GCN-SVD | `H2GCN`      | `--adj_svd_rank {k}` (select the best `{k}` per dataset) |
| GraphSAGE-SVD | `H2GCN` | `--adj_nhood ['1'] --network_setup I-T1-G-V-C1-M64-R-T2-G-V-C2-MO-R --adj_norm_type rw --adj_svd_rank {k}` (select the best `{k}` per dataset) |
| H2GCN | `H2GCN` | (Empty) |
| GraphSAGE | `H2GCN` | `--adj_nhood ['1'] --network_setup I-T1-G-V-C1-M64-R-T2-G-V-C2-MO-R --adj_norm_type rw` |
| CPGNN | `CPGNN` | `--network_setup M64-R-MO-E-BP2` |
| GPR-GNN | `GPRGNN` | `--nhid 64 --alpha {gprgnn_alpha}` (select the best `{gprgnn_alpha}` overall) |
| FAGCN | `FAGCN` | `--nhid 64 --eps {fagcn_eps} --dropout 0.5` (select the best `{fagcn_eps}` overall)|
| GNNGuard | `GNNGuard` | `--nhid 64 --base_model GCN_fixed` |
| ProGNN | `ProGNN` | `--nhid 64` |
| GCN-SVD | `GCNSVD` | `--nhid 64 --svd_solver eye-svd --k {k}` (select the best `{k}` per dataset) |
| GAT | `GAT` | (Empty) |
| GCN | `MultiLayerGCN` | `--nhid 64 --nlayer 2` |
| MLP | `H2GCN` | `--network_setup M64-R-D0.5-MO` |



## Results

Run the jupyter notebook under `./results/` for analyzing the results.
* For Nettack, please run `./results/iclr21-adj-only-nettack/ICLR-nettack.ipynb`
* For Metattack, please run `./results/iclr21-adj-only-metattack/ICLR-metattack.ipynb`.
* For Certifiable robustness, please run `./results/iclr21-adj-only-cert/ICLR-cert.ipynb`

Refer to the Appendix of the paper for detailed results.
