import librosa
import soundfile as sf
import os
from tqdm import tqdm

def resample_wavs_in_folder(input_folder, output_folder, target_sr=16000):
    # Ensure the output folder exists
    os.makedirs(output_folder, exist_ok=True)

    # Get all wav files in the input folder
    wav_files = [f for f in os.listdir(input_folder) if f.endswith('.wav')]

    for wav_file in tqdm(wav_files, desc="Resampling WAV files"):
        input_wav_path = os.path.join(input_folder, wav_file)
        output_wav_path = os.path.join(output_folder, wav_file)

        # Load the original wav file
        y, sr = librosa.load(input_wav_path, sr=22050)

        # Resample to the target sampling rate (16000Hz)
        y_resampled = librosa.resample(y, orig_sr=sr, target_sr=target_sr)

        # Save the resampled wav file
        sf.write(output_wav_path, y_resampled, target_sr)

    print(f"Resampling completed. All files saved to {output_folder}")

# Example usage
input_folder = './LJSpeech-1.1-22/wavs'  # Replace with your input folder path
output_folder = './LJSpeech-1.1/wavs'   # Replace with your desired output folder path
resample_wavs_in_folder(input_folder, output_folder)
