from matplotlib import pyplot as plt 
import matplotlib
from six.moves import cPickle as pkl
import numpy as np
import seaborn as sns
sns.set_theme()

matplotlib.rcParams['pdf.fonttype'] = 42
matplotlib.rcParams['ps.fonttype'] = 42
SMALL_SIZE = 15
MEDIUM_SIZE = 20
BIGGER_SIZE = 20

plt.rc('font', size=SMALL_SIZE)          # controls default text sizes
plt.rc('axes', titlesize=SMALL_SIZE)     # fontsize of the axes title
plt.rc('axes', labelsize=MEDIUM_SIZE)    # fontsize of the x and y labels
plt.rc('xtick', labelsize=SMALL_SIZE)    # fontsize of the tick labels
plt.rc('ytick', labelsize=SMALL_SIZE)    # fontsize of the tick labels
plt.rc('legend', fontsize=9)             # legend fontsize
plt.rc('figure', titlesize=BIGGER_SIZE)  # fontsize of the figure title

with open('data.pkl', 'rb') as f:
    data = pkl.load(f)

plt.figure(dpi=150)

for i, h in enumerate([16, 32, 64, 128]):
    tv, err = [], []
    for v in [10, 20, 30, 40]:
        tv.append(data[v][3][h][0])
        err.append(data[v][3][h][1])
    tv, err = np.stack(tv), np.stack(err)
    plt.plot([10, 20, 30, 40], tv, '-o', label='h = {}'.format(h), color='C'+str(i))
    plt.fill_between([10, 20, 30, 40], tv-err, tv+err, alpha=0.5, color='C'+str(i))
    
plt.xlabel('Vocabulary size')
plt.ylabel('Total variation')
plt.xticks([10, 20, 30, 40])
plt.title('Sequence length = 3')
plt.legend(title='LSTM hidden dimension')
plt.tight_layout()
plt.savefig('v.png')