import numpy as np
import torch
import torch.nn.functional as F
from matplotlib import pyplot as plt
from PIL import Image
import torchvision
from datasets import load_dataset
from torchvision import transforms

import matplotlib.pyplot as plt

import base64
from io import BytesIO

import datetime

import os, json

from diffusers import DDPMScheduler, UNet2DModel, DDPMPipeline

from torch.autograd.functional import jacobian
from concurrent.futures import ThreadPoolExecutor

from tqdm import tqdm

import sys
sys.path.append("/home/***/work/doob_apps/hug")

from src.utils.img_func import show_images, make_grid, preprocess, transform

def main():
    # sample_ref.pyの生成した画像を表示する
    # 画像のtensorを読み込む

    dirname = "/home/***/work/doob_apps/hug/outputs/samples/tests"
    # 日付を取得
    dt_now = datetime.datetime.now()
    # フォルダ名を作成
    dirname = os.path.join(dirname, dt_now.strftime("%Y%m%d_%H%M%S"))
    # フォルダを作成
    os.makedirs(dirname, exist_ok=True)

    images = torch.load("/home/***/work/doob_apps/hug/outputs/samples/20240910_101059/samples_ref.pth")
    print("image.shape:", images.shape)
    # (batch_size, channel, height, width)になっている
    img = show_images(images)
    plt.imshow(img)
    plt.axis("off")
    plt.savefig(dirname + "/butterfly.png")

    print("sample_ref.pyの生成した画像を表示しました")

if __name__ == "__main__":
    main()