import math
from src.utils.set_seed import set_seed


def xavier_init(model, beta=1):
    """ Xavierの初期化

    Args:
        model (object): モデル
    """
    for name, param in model.named_parameters():
        if name.endswith(".bias"):
            param.data.fill_(0)
        else:
            if beta == 0:
                bound = 0
            else:
                bound = math.sqrt(6)/math.sqrt(param.shape[0]+param.shape[1])/beta
            param.data.uniform_(-bound, bound)