import torch
import numpy as np
import math

pi = torch.tensor(math.pi)

def convert_to_tensor(x, device="cuda"):
    # device = torch.device("cuda" if torch.cuda.is_available() else "cpu")
    if isinstance(x, np.ndarray):
        return torch.tensor(x).to(device)
    return x

def new_target_potential(x, device="cuda"):
    # device = torch.device("cuda" if torch.cuda.is_available() else "cpu")
    x = convert_to_tensor(x, device)
    def new_log_ratio(x, newxy):
        sgm = 10
        return torch.exp(-(x[0]-newxy[0])**2/(2*sgm)-(x[1]-newxy[1])**2/(2 * sgm))/torch.sqrt(2*sgm*torch.tensor(pi).to(device))
    eps = 1e-10
    beta = 1
    gamma = 300
    mean_win = [2,2]
    mean_lose = [-2,-2]
    potential = -(- torch.log((1+eps)/(1+ beta * new_log_ratio(x,mean_win)+eps))-1 + (1+eps)/(1+beta*new_log_ratio(x,mean_win)+eps) )# +(- torch.log((1+eps)/(1+beta*new_log_ratio(x,mean_lose)+eps))-1 + (1+eps)/(1+beta*new_log_ratio(x,mean_lose)+eps) )
    return gamma * potential