import torch
import torch.nn as nn
import torch.nn.functional as F
import pandas as pd
import numpy as np
from tqdm import tqdm
from torch.utils.tensorboard import SummaryWriter
from src.models.nn_potential import ApproxPotential
from src.potentials.target_potential import new_target_potential
import matplotlib.pyplot as plt

def main():
    device = torch.device("cuda" if torch.cuda.is_available() else "cpu")

    model_potential = ApproxPotential(2).to(device)
    model_potential.load_state_dict(torch.load('outputs/potential/score_base_model.pth'))

    model_potential.eval()

    # テストデータの準備
    x_test = torch.rand(1000, 2).to(device) * 10 - 5
    
    # 真の値とニューラルネットの予測値を計算
    with torch.no_grad():
        y_true = torch.tensor([new_target_potential(x) for x in x_test]).unsqueeze(1).to(device)
        y_pred = model_potential(x_test)

    # 結果をNumPy配列に変換
    y_true_np = y_true.cpu().numpy().flatten()
    y_pred_np = y_pred.cpu().numpy().flatten()

    # 散布図を作成
    plt.figure(figsize=(8, 6))
    plt.scatter(y_true_np, y_pred_np, alpha=0.5)
    plt.xlabel('True potential')
    plt.ylabel('Predicted potential')
    plt.title('Comparison of True and Predicted')

    # y=x の直線を追加
    plt.plot([y_true_np.min(), y_true_np.max()], [y_true_np.min(), y_true_np.max()], 'k--')

    plt.savefig('outputs/figures/potential/potential.png')

if __name__ == "__main__":
    main()