# Supplemental Materials for the Paper  
**"Influence Functions for Edge Edits in Non-Convex Graph Neural Networks"**

## Setup

To set up the environment, run the following commands:
```
conda create --name {ENV_NAME} python=3.9
conda install pytorch==2.5.0 torchvision==0.20.0 torchaudio==2.5.0 pytorch-cuda=12.1 -c pytorch -c nvidia
pip install torch_geometric
pip install pyg_lib torch_scatter torch_sparse torch_cluster torch_spline_conv -f https://data.pyg.org/whl/torch-2.5.0+cu121.html
pip install matplotlib
```

---

## Tutorial

We provide a minimal working example in `tutorial.py`, which demonstrates how to compute influence scores for a set of candidate edge edits.  

---

## Reproduce the Results in Figure 2

To reproduce the scatter plot comparing predicted influence and actual influence (as shown in Figure 2 of the paper), run the following command:
```
bash reproduce.sh
```
The resulting plot and data will be saved under the `configs/results/` directory.