#!/bin/bash

INPUT_DIR="./configs"
PYTHON_SCRIPT="calculate_influence.py"
GPU_COUNT=8

files=("$INPUT_DIR"/*.json)
num_files=${#files[@]}

declare -a gpu_busy
for ((i=0; i<GPU_COUNT; i++)); do
    gpu_busy[$i]=0
done

get_available_gpu() {
    for ((g=0; g<GPU_COUNT; g++)); do
        if [ "${gpu_busy[$g]}" -eq 0 ]; then
            echo $g
            return
        fi
    done
    echo -1
}

wait_for_any_gpu() {
    wait -n
    for pid in "${!gpu_pids[@]}"; do
        if ! kill -0 "${gpu_pids[$pid]}" 2>/dev/null; then
            gpu_busy[$pid]=0
            unset gpu_pids[$pid]
        fi
    done
}

declare -A gpu_pids
for file in "${files[@]}"; do
    while true; do
        gpu_id=$(get_available_gpu)
        if [ "$gpu_id" -ge 0 ]; then
            echo "Launching $PYTHON_SCRIPT on GPU $gpu_id with input $file"
            CUDA_VISIBLE_DEVICES=$gpu_id python "$PYTHON_SCRIPT" --json_config "$file" &
            pid=$!
            gpu_busy[$gpu_id]=1
            gpu_pids[$gpu_id]=$pid
            break
        else
            wait_for_any_gpu
        fi
    done
done
wait