import random
import pickle5 as pickle
import os
import numpy as np
from PIL import Image

frame_dict ={}

SEEN_WEATHER = ['ClearSunset', 'ClearNoon', 'CloudySunset', 'CloudyNight',
                'CloudyNoon', 'MidRainSunset', 'MidRainyNight', 'MidRainyNoon',
                'SoftRainNight'] 
DOMAIN_FACTORS = ['brake','camera','steer','throttle','weather']

import random



df = DOMAIN_FACTORS[4]
with open(f'/home/andykim0723/LUSR/carla_data/{df}/train_dataset.pkl','rb') as f:
    data = pickle.load(f)

    img_lists = []
    if df == 'weather':
        for k,v in data.items():
            if k in SEEN_WEATHER:
                imgs = v['frame']
                imgs = np.array(imgs)
                img_lists.append(imgs)
        frames = np.concatenate(img_lists,axis=0)
        img_len = frames.shape[0]
        idxes = np.random.randint(img_len,size=5000) 
        frames = frames[idxes]
        print(frames.shape)
    else:
        for k,v in data.items():
            if isinstance(k,float):
                imgs = v['frame']
                imgs = np.array(imgs)
                img_lists.append(imgs)
        frames = np.concatenate(img_lists,axis=0)
        img_len = frames.shape[0]
        idxes = np.random.randint(img_len,size=5000) 
        frames = frames[idxes]
        print(frames.shape)
        
## save
dest_path = os.path.join('lusr_data',df)
if not os.path.exists(dest_path):
        os.mkdir(dest_path)   
np.savez(os.path.join(dest_path,'0.npz'),obs=frames)

