# ✨ Defining a New Task

In order to define a new task or change any component of the training procedure, it suffices to look into/change the following files and classes.

## ManipulaTHOR Environment

The `ManipulaTHOREnvironment` class defined in `ithor_arm/ithor_arm_environment.py` is a wrapper around the AI2-THOR environment which helps with discretizing the action space for the ArmPointNav task and wraps the functions that are needed for working with the low-level manipulation feature, including getting the arm's pose, agent's pose, etc.  

#### Important Functions

1. `step`: This function translates the actions generated by the model to their corresponding AI2THOR API commands. For example, for the action `MoveHandXUp`, this function calculates the current arm location, increments the `x` value by `0.05` (which is our step size), and calls the function `MoveMidLevelArm` with the desires `x,y,z` values.

1. `get_objects_moved`: Finds the objects that have moved from the previous action. We only use this function during evaluation for calculating the Success Without Disturbance metric. However, it can be used for reward shaping as well.

1. `get_current_arm_state`: Calculates the current arm state from the metadata of the environment.

2. `is_object_at_low_level_hand`: Checks whether the object is at hand or not.

## ArmPointNav Task Sampler

You can find `ArmPointNavTaskSampler` in `ithor_arm/ithor_arm_task_samplers.py`. This class is in charge of reading the dataset metadata, initializing the all possible locations for the object and agent and randomly sampling a data point from this set for each episode.

#### Important Functions

1. `calc_possible_trajectories`: This function stores all the possible locations of the objects on the counters in a dictionary sorted by the object names.
2. `get_source_target_indices`: This function returns two indices from the dictionary calculated above for the initial and goal location of the object.
3. `next_task`: Gets the source and target locations, resets the scene, initializes the agent and transport the object to its initial location.


## ArmPointNav Task

You can find `ArmPointNavTask` in `ithor_arm/ithor_arm_tasks.py`. This class includes the possible actions, reward definition, metric calculation and recording and calling the appropriate API functions on the environment.

#### Important Functions and Attributes

1. `_actions`: An attribute storing all the possible actions for each task. Note that this is an ordered list.
2. `judge`: The function for calculating the reward. Any reward shaping should be done in this function. 
3. `metrics`: Calculates and logs the value of each evaluation metric per episode.