from typing import Optional
import os
from .imagelist import PklImageListIthor

class IthorLoader(PklImageListIthor):
    objnav_data_dict = {
        "FOV": "train_dataset.pkl",
        "STEPSIZE": "train_dataset.pkl",
        "ROTATE": "train_dataset.pkl",
    }
    CLASSES = ['Drawer', 'Floor', 'CounterTop', 'Mirror', 'StoveBurner', 'Cabinet', 'SideTable', 'Sink', 'GarbageBag', 
                'CoffeeMachine', 'Toaster', 'Pot', 'Plate', 'GarbageCan', 'StoveKnob', 'Fork', 'SoapBottle', 'Fridge', 
                'Pan', 'Window', 'Egg', 'Spatula', 'Microwave', 'Cup', 'SinkBasin', 'SaltShaker', 'PepperShaker', 
                'ButterKnife', 'DishSponge', 'LightSwitch', 'Spoon', 'Knife', 'Shelf', 'Mug', 'DiningTable', 'Blinds', 
                'AluminumFoil', 'Faucet', 'Bowl', 'Chair']

    def __init__(self, root: str, task: str = "pair", download: Optional[bool] = False, **kwargs):
        image_file_list = list(self.objnav_data_dict.items())
        data_file_list = [os.path.join(root, factor, image_file) for factor, image_file in image_file_list]
        
        super(IthorLoader, self).__init__(root, IthorLoader.CLASSES, data_file_list=data_file_list, **kwargs)

    @classmethod
    def domains(cls):
        return list(cls.objnav_data_dict.keys())